<!DOCTYPE html>
<html lang="zxx">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <meta name="description" content="FPL Maestros - Team-Based Fantasy Premier League Competition">
    <meta name="keywords" content="FPL, Fantasy Premier League, Football, Soccer, Premier League">
    <meta name="author" content="FPL Maestros">
    <!-- Page Title -->
    <title>FPL Maestros - Team-Based Fantasy Premier League</title>
    <?php include('nav.php') ?>

    <!-- Hero Section Start -->
    <div class="hero dark-section" style="background: linear-gradient(135deg, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0.6) 100%), url('https://images.unsplash.com/photo-1556056504-5c7696c4c28d?ixlib=rb-4.0.3&auto=format&fit=crop&w=1920&q=80') center/cover no-repeat;">
        <div class="container">
            <div class="row align-items-center min-vh-80">
                <div class="col-lg-8 mx-auto text-center">
                    <!-- Hero Content Start -->
                    <div class="hero-content">
                        <!-- Section Title Start -->
                        <div class="section-title">
                            <!-- <div class="badge bg-primary mb-3 wow fadeInUp" style="font-size: 1.1em; padding: 0.5rem 1.5rem;">
                                Season 2024/25 Now Live!
                            </div> -->
                            <h3 class="wow fadeInUp text-light mb-3">Assemble. Compete. Triumph.</h3>
                            <h1 class="text-anime-style-2 display-4 fw-bold mb-4" data-cursor="-opaque" style="line-height: 1.2;">
                                Welcome to <span class="text-primary">FPL Maestros</span> 
                                <span class="d-block fs-3 mt-2">Where Strategy Meets Teamwork</span>
                            </h1>
                        </div>
                        <!-- Section Title End -->

                        <!-- Hero Content List Start -->
                        <div class="hero-content-list wow fadeInUp" data-wow-delay="0.2s">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <div class="d-flex justify-content-around flex-wrap">
                                        <div class="text-center mx-3 mb-3">
                                            <div class="fs-2 fw-bold text-primary mb-3">20</div>
                                            <div class="text-light">Teams of 5 Managers</div>
                                        </div>
                                        <div class="text-center mx-3 mb-3">
                                            <div class="fs-2 fw-bold text-primary  mb-3">H2H</div>
                                            <div class="text-light">League Format</div>
                                        </div>
                                        <div class="text-center mx-3 mb-3">
                                            <div class="fs-2 fw-bold text-primary  mb-3">38</div>
                                            <div class="text-light">Gameweeks</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Hero Content List End -->

                        <!-- Hero Content Body Start -->
                        <div class="hero-content-body wow fadeInUp" data-wow-delay="0.4s">
                            <p class="lead text-light mb-4">FPL Maestros revolutionizes Fantasy Premier League with team-based competition. Join forces with 4 other managers and battle it out in the ultimate strategic football experience.</p>
                        </div>
                        <!-- Hero Content Body End -->

                        <!-- Hero Button Start -->
                        <!-- <div class="hero-btn wow fadeInUp" data-wow-delay="0.6s">
                            <div class="d-flex flex-wrap justify-content-center gap-3">
                                <a href="fixtures-and-results.php" class="btn btn-primary btn-lg px-4 py-2">
                                    <i class="fas fa-calendar-alt me-2"></i>View Fixtures
                                </a>
                                <a href="teams.php" class="btn btn-outline-light btn-lg px-4 py-2">
                                    <i class="fas fa-users me-2"></i>Explore Teams
                                </a>
                                <a href="league-table.php" class="btn btn-outline-light btn-lg px-4 py-2">
                                    <i class="fas fa-trophy me-2"></i>League Table
                                </a>
                            </div>
                        </div> -->
                        <div class="hero-btn wow fadeInUp" data-wow-delay="0.6s">
                            <a href="fixtures-and-results.php" class="btn-default" style="background: transparent; color: white; border: 2px solid white;">View Fixtures & Results</a>
                        </div>
                        <!-- Hero Button End -->
                    </div>
                    <!-- Hero Content End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Hero Section End -->

    <!-- Live Updates Bar -->
    <!-- <div class="bg-dark py-2 border-bottom border-primary">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <span class="badge bg-danger me-2">LIVE</span>
                    <small class="text-light">Gameweek Updates</small>
                </div>
                <div class="col-md-9">
                    <marquee behavior="scroll" direction="left" class="text-light">
                        ⚽ Latest Results Loading... | 🏆 League Standings Updating... | 📊 Manager Points Being Calculated...
                    </marquee>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Scrolling Ticker Section Start -->
    <div class="our-scrolling-ticker bg-light py-3">
        <div class="container">
            <h6 class="text-center text-muted mb-3">FEATURED TEAMS</h6>
            <div class="scrolling-ticker-box">
                <div class="scrolling-content" id="lg-teams"></div>
                <div class="scrolling-content" id="lg-teams-2"></div>
            </div>
        </div>
    </div>

    <!-- League Stats Section Start -->
    <div class="section dark-section py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title text-center mb-5">
                        <h3 class="wow fadeInUp text-light">League Statistics</h3>
                        <h2 class="text-anime-style-2 display-5 fw-bold" data-cursor="-opaque">FPL Maestros <span class="text-primary">By The Numbers</span></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="stat-box wow fadeInUp" data-wow-delay="0.1s">
                        <div class="stat-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h3 class="counter" data-count="100">0</h3>
                        <p>Active Managers</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="stat-box wow fadeInUp" data-wow-delay="0.2s">
                        <div class="stat-icon">
                            <i class="fas fa-chess-board"></i>
                        </div>
                        <h3 class="counter" data-count="20">0</h3>
                        <p>Competitive Teams</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="stat-box wow fadeInUp" data-wow-delay="0.3s">
                        <div class="stat-icon">
                            <i class="fas fa-futbol"></i>
                        </div>
                        <h3 class="counter" data-count="38">0</h3>
                        <p>Gameweeks</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="stat-box wow fadeInUp" data-wow-delay="0.4s">
                        <div class="stat-icon">
                            <i class="fas fa-trophy"></i>
                        </div>
                        <h3 class="counter" data-count="1">0</h3>
                        <p>Ultimate Champion</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- League Stats Section End -->

    <!-- How It Works Section Start -->
    <div class="section bg-light py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title text-center mb-5">
                        <h3 class="wow fadeInUp">Competition Format</h3>
                        <h2 class="text-anime-style-2 display-5 fw-bold" data-cursor="-opaque">How FPL Maestros <span class="text-primary">Works</span></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="step-box wow fadeInUp" data-wow-delay="0.1s">
                        <div class="step-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="step-number">1</div>
                        <h4>Form Teams</h4>
                        <p>Managers join together in teams of 5, combining their FPL expertise and strategies.</p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="step-box wow fadeInUp" data-wow-delay="0.2s">
                        <div class="step-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <div class="step-number">2</div>
                        <h4>Weekly Matchups</h4>
                        <p>Each week, teams face off in head-to-head battles with combined scores determining the winner.</p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="step-box wow fadeInUp" data-wow-delay="0.3s">
                        <div class="step-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="step-number">3</div>
                        <h4>League Standings</h4>
                        <p>Teams earn 3 points for a win, 1 for a draw, and 0 for a loss in the season-long competition.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- How It Works Section End -->

    <!-- CTA Section -->
    <!-- <div class="section dark-section py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h3 class="text-light mb-2">Ready to Join the Competition?</h3>
                    <p class="text-light mb-0">Register your team and start your journey to become FPL Maestros champions.</p>
                </div>
                <div class="col-lg-4 text-lg-end">
                    <a href="#" class="btn btn-light btn-lg px-4">
                        <i class="fas fa-user-plus me-2"></i>Register Now
                    </a>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Footer would be included here -->
    <?php include('footer.php') ?>

    <!-- Additional CSS for new sections -->
    <style>
        .min-vh-80 {
            min-height: 80vh;
        }
        
        .hero {
            position: relative;
            overflow: hidden;
        }
        
        .stat-box {
            text-align: center;
            padding: 40px 20px;
            border-radius: 15px;
            background: rgba(255, 255, 255, 0.1);
            margin-bottom: 30px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .stat-box:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }

        .stat-icon {
            font-size: 50px;
            color: #667eea;
            margin-bottom: 20px;
        }

        .stat-box h3 {
            font-size: 48px;
            font-weight: 800;
            color: #667eea;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }

        .stat-box p {
            font-size: 18px;
            color: #fff;
            font-weight: 500;
        }

        .step-box {
            text-align: center;
            padding: 40px 30px;
            border-radius: 15px;
            background: #fff;
            margin-bottom: 30px;
            position: relative;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid #e9ecef;
            height: 100%;
        }

        .step-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .step-icon {
            font-size: 50px;
            color: #667eea;
            margin-bottom: 20px;
        }

        .step-number {
            position: absolute;
            top: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px;
            height: 40px;
            background: #667eea;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 18px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .step-box h4 {
            margin-top: 15px;
            margin-bottom: 15px;
            color: #2d3748;
            font-weight: 700;
        }

        .step-box p {
            color: #666;
            line-height: 1.6;
        }

        .scrolling-ticker-box {
            background: white;
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .scrolling-content span {
            display: inline-flex;
            align-items: center;
            margin: 0 20px;
            padding: 10px 15px;
            background: var(--accent-color);
            /* background: #f8f9fa; */
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .scrolling-content span:hover {
            background: #667eea;
            color: white;
            transform: scale(1.05);
        }

        .scrolling-content img {
            margin-right: 10px;
        }

        @media (max-width: 768px) {
            .hero-btn .btn {
                display: block;
                width: 100%;
                margin-bottom: 10px;
            }
            
            .display-4 {
                font-size: 2rem;
            }
            
            .stat-box {
                padding: 30px 15px;
            }
            
            .step-box {
                padding: 30px 20px;
            }
        }
    </style>

    <script>
        $(document).ready(function() {
            // Load teams for scrolling ticker
            $.ajax({
                url: "admin/connect.php",
                method: "GET",
                data: {
                    fetchLeagueTeams: "Yes"
                },
                success: function(data) {
                    let teams = $('#lg-teams');
                    let teams2 = $('#lg-teams-2');
                    teams.empty();
                    teams2.empty();
                    data.forEach(f => {
                        let span = `<span>
                            <img src="admin/uploads/${f.logo}" alt="${f.team_name}" 
                                 onerror="this.src='images/icon-football.svg'" 
                                 style="height: 32px; width: 32px; object-fit: contain; border-radius: 50%;">
                            ${f.team_name}
                        </span>`;
                        teams.append(span);
                        teams2.append(span);
                    });
                }
            });

            // Animated counter for stats
            function animateCounter() {
                $('.counter').each(function() {
                    const $this = $(this);
                    const target = parseInt($this.data('count'));
                    const duration = 2000;
                    const step = target / (duration / 16);
                    let current = 0;
                    
                    const timer = setInterval(() => {
                        current += step;
                        if (current >= target) {
                            $this.text(target);
                            clearInterval(timer);
                        } else {
                            $this.text(Math.floor(current));
                        }
                    }, 16);
                });
            }

            // Initialize counter when stats section is in view
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        animateCounter();
                        observer.unobserve(entry.target);
                    }
                });
            });

            observer.observe(document.querySelector('.dark-section'));
        });
    </script>
</body>
</html>