<!DOCTYPE html>
<html lang="zxx">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <meta name="description" content="FPL Maestros - Team-Based Fantasy Premier League Fixtures and Results">
    <meta name="keywords" content="FPL, Fantasy Premier League, Football, Soccer, Premier League, Fixtures, Results">
    <meta name="author" content="FPL Maestros">
    <!-- Page Title -->
    <title>FPL Maestros - Fixtures and Results</title>

    <!-- FPL Color Theme -->
    <style>
        :root {
            --primary-color: #37003c;
            --secondary-color: #FFFFFF1A;
            --text-color: #999999;
            --accent-color: #00ff85;
            --white-color: #FFFFFF;
            --divider-color: #0315211A;
            --dark-divider-color: #FFFFFF1A;
            --error-color: rgb(230, 87, 87);
            --default-font: "Manrope", sans-serif;
            --accent-font: "Bebas Neue", sans-serif;

            /* Division Colors */
            --premier-color: #37003c;
            --championship-color: #1e40af;
            --league-one-color: #059669;
        }

        .dark-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, #1f0022 100%) !important;
        }

        .page-header {
            background: var(--primary-color);
            padding: 4rem 0 2rem;
        }

        .page-header-box p.lead {
            color: #e2e8f0 !important;
            font-size: 1.25rem;
        }

        /* Division Tabs - FIXED: Removed border-bottom from individual tabs */
        .division-tabs {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 1rem;
            margin-bottom: 2rem;
            display: flex;
            gap: 0.5rem;
        }

        .division-tab {
            padding: 1rem 2rem;
            border: none;
            background: transparent;
            color: var(--text-color);
            border-radius: 10px;
            transition: all 0.3s ease;
            font-weight: 600;
            flex: 1;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .division-tab.active {
            background: var(--accent-color);
            color: var(--primary-color);
        }

        /* FIXED: Removed individual border classes that were causing badge-like appearance */
        .division-tab:hover:not(.active) {
            background: rgba(255, 255, 255, 0.1);
            color: var(--white-color);
        }

        /* Division Content */
        .division-content {
            display: none;
        }

        .division-content.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* League Table */
        .league-table-container {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 1.5rem;
            border: 1px solid var(--dark-divider-color);
            margin-bottom: 2rem;
        }

        .table {
            color: var(--white-color);
            margin-bottom: 0;
        }

        .table thead th {
            background-color: var(--primary-color);
            color: var(--accent-color);
            border-bottom: 2px solid var(--accent-color);
            font-weight: 600;
            padding: 1rem 0.75rem;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .table tbody tr {
            transition: all 0.3s ease;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .table tbody tr:hover {
            background-color: rgba(0, 255, 133, 0.1);
            /* transform: translateX(5px); */
        }

        .team-cell {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 600;
        }

        .team-logo-table {
            width: 32px;
            height: 32px;
            object-fit: contain;
            border-radius: 6px;
            background: white;
            padding: 2px;
        }

        /* Position indicators */
        .position-cell {
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(1) .position-cell {
            background: linear-gradient(135deg, #FFD700, #FFED4E);
            color: #856404;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        tr:nth-child(2) .position-cell,
        tr:nth-child(3) .position-cell,
        tr:nth-child(4) .position-cell {
            background: #e3f2fd;
            color: #1976d2;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        /* FIXED FIXTURES SECTION - Added position: relative */
        .fixtures-container {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 1.5rem;
            border: 1px solid var(--dark-divider-color);
        }

        .fixture-card {
            background: rgba(255, 255, 255, 0.08);
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            position: relative;
            /* FIXED: Added position relative for badge positioning */
        }

        .fixture-card:hover {
            background: rgba(255, 255, 255, 0.12);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        /* Desktop Layout - 3 columns */
        .fixture-content {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            align-items: center;
            gap: 1.5rem;
        }

        .fixture-team {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        .team-logo-fixture {
            width: 50px;
            height: 50px;
            object-fit: contain;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            background: white;
            padding: 4px;
            transition: transform 0.3s ease;
            /* Added for better UX */
        }

        .fixture-card:hover .team-logo-fixture {
            transform: scale(1.05);
            /* Subtle scale on hover */
        }

        .team-name {
            font-weight: 600;
            color: var(--white-color);
            font-size: 0.95em;
        }

        .fixture-center {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        .fixture-score {
            font-size: 1.8em;
            font-weight: bold;
            color: var(--white-color);
            margin-bottom: 0.25rem;
        }

        .fixture-points {
            font-size: 0.9em;
            color: var(--accent-color);
            font-weight: 600;
            background: rgba(0, 255, 133, 0.1);
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            margin-top: 0.25rem;
        }

        .fixture-status {
            position: absolute;
            top: 12px;
            right: 12px;
            z-index: 2;
            /* FIXED: Ensure badge is above other content */
        }

        .badge {
            font-size: 0.7em;
            padding: 0.4em 0.8em;
            border-radius: 12px;
            color: white;
            font-weight: 600;
            display: inline-block;
            /* FIXED: Ensure proper display */
        }

        .badge-live {
            background: #dc3545;
            animation: pulse 2s infinite;
        }

        .badge-completed {
            background: #28a745;
        }

        .badge-scheduled {
            background: #6c757d;
        }

        @keyframes pulse {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0.7;
            }

            100% {
                opacity: 1;
            }
        }

        /* Goalscorers Section */
        .goalscorers-section {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 1.5rem;
            border: 1px solid var(--dark-divider-color);
            margin-bottom: 2rem;
        }

        .goalscorers-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }

        .goalscorer-card {
            background: rgba(255, 255, 255, 0.08);
            border-radius: 12px;
            padding: 1rem;
            display: flex;
            align-items: center;
            gap: 1rem;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .goalscorer-card:hover {
            background: rgba(255, 255, 255, 0.12);
            transform: translateY(-2px);
        }

        .goalscorer-rank {
            width: 36px;
            height: 36px;
            background: var(--accent-color);
            color: var(--primary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.1em;
        }

        .goalscorer-info {
            flex: 1;
        }

        .goalscorer-name {
            font-weight: 600;
            color: var(--white-color);
            margin-bottom: 0.25rem;
        }

        .goalscorer-team {
            font-size: 0.85em;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .goalscorer-stats {
            text-align: right;
        }

        .goalscorer-goals {
            font-size: 1.5em;
            font-weight: bold;
            color: var(--accent-color);
        }

        .goalscorer-label {
            font-size: 0.75em;
            color: var(--text-color);
            text-transform: uppercase;
        }

        /* Goalscorer Rank Colors */
        .rank-gold {
            background: linear-gradient(135deg, #FFD700, #FFED4E);
            color: #856404;
        }

        .rank-silver {
            background: linear-gradient(135deg, #C0C0C0, #E0E0E0);
            color: #555;
        }

        .rank-bronze {
            background: linear-gradient(135deg, #CD7F32, #E0A040);
            color: #5a3921;
        }

        /* Stats */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            background: rgba(255, 255, 255, 0.08);
        }

        .stat-number {
            font-size: 2.5em;
            font-weight: bold;
            color: var(--accent-color);
            display: block;
            line-height: 1;
        }

        .stat-label {
            font-size: 0.9em;
            color: var(--text-color);
            margin-top: 0.5rem;
        }

        .form-select {
            background-color: var(--secondary-color);
            color: var(--white-color);
            border: 1px solid var(--dark-divider-color);
            border-radius: 8px;
            padding: 0.5rem 1rem;
        }

        .form-select:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 0.2rem rgba(0, 255, 133, 0.25);
        }

        /* MOBILE OPTIMIZATIONS - FIXED LAYOUT */
        @media (max-width: 768px) {
            .division-tabs {
                flex-direction: column;
                gap: 0.5rem;
            }

            .division-tab {
                padding: 0.75rem 1rem;
            }

            /* FIXED: Score stays between teams on mobile */
            .fixture-content {
                grid-template-columns: 1fr auto 1fr;
                gap: 0.75rem;
            }

            .team-logo-fixture {
                width: 40px;
                height: 40px;
            }

            .fixture-score {
                font-size: 1.5em;
            }

            .league-table-container,
            .fixtures-container,
            .goalscorers-section {
                padding: 1rem;
            }

            .page-header {
                padding: 2rem 0 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .table-responsive {
                font-size: 0.875em;
            }

            .team-logo-table {
                width: 24px;
                height: 24px;
            }

            .goalscorers-grid {
                grid-template-columns: 1fr;
            }

            .fixture-status {
                position: static;
                grid-column: 1 / -1;
                justify-self: center;
                margin-top: 0.5rem;
            }

            .page-header-box p.lead {
                font-size: 1.1rem;
            }
        }

        @media (max-width: 576px) {
            .fixture-card {
                padding: 1rem;
            }

            .team-name {
                font-size: 0.85em;
            }

            .fixture-score {
                font-size: 1.3em;
            }

            .goalscorer-card {
                padding: 0.75rem;
            }

            .fixture-content {
                gap: 0.5rem;
            }
        }

        /* Division-specific styles - FIXED: Cleaned up border implementation */
        .division-tab.premier.active {
            box-shadow: 0 0 0 2px var(--premier-color);
        }

        .division-tab.championship.active {
            box-shadow: 0 0 0 2px var(--championship-color);
        }

        .division-tab.league-one.active {
            box-shadow: 0 0 0 2px var(--league-one-color);
        }

        .premier-division .division-header {
            color: var(--premier-color);
        }

        .championship-division .division-header {
            color: var(--championship-color);
        }

        .league-one-division .division-header {
            color: var(--league-one-color);
        }
    </style>

    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    

    <?php include('nav.php') ?>

    <!-- Page Header Start -->
    <div class="page-header dark-section-2">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-header-box text-center">
                        <h1 class="text-anime-style-2 display-4 fw-bold" data-cursor="-opaque">
                            Fixtures & Results<span></span>
                        </h1>
                        <p class="lead mt-3">Track matches, results, and standings across all divisions</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Page Header End -->

    <!-- Main Content Section -->
    <div class="our-schedule dark-section-2 parallaxie py-5">
        <div class="container">
            <!-- Division Tabs - FIXED: Removed problematic border classes -->
            <div class="division-tabs d-flex flex-wrap">
                <button class="division-tab premier active" data-division="1">
                    <i class="fas fa-crown me-2"></i>Division 1
                </button>
                <button class="division-tab championship" data-division="2">
                    <i class="fas fa-arrow-up me-2"></i>Division 2
                </button>
                <button class="division-tab league-one" data-division="3">
                    <i class="fas fa-futbol me-2"></i>Division 3
                </button>
            </div>

            <!-- Quick Stats -->
            <div class="stats-grid" id="division-stats">
                <div class="stat-card">
                    <span class="stat-number" id="total-teams">20</span>
                    <span class="stat-label">Teams</span>
                </div>
                <div class="stat-card">
                    <span class="stat-number" id="total-matches">0</span>
                    <span class="stat-label">Matches Played</span>
                </div>
                <!-- <div class="stat-card">
                    <span class="stat-number" id="live-matches">0</span>
                    <span class="stat-label">Live Now</span>
                </div> -->
                <div class="stat-card">
                    <span class="stat-number" id="total-goals">0</span>
                    <span class="stat-label">Goals Scored</span>
                </div>
            </div>



            <!-- Division Content -->
<div class="division-content active premier-division" data-division="1">
    <div class="row">
        <!-- League Table Column -->
        <div class="col-lg-7 mb-4">
            <div class="our-schedule-content">
                <div class="section-title mb-4">
                    <h3 class="wow fadeInUp text-light">Division 1</h3>
                    <h2 class="text-anime-style-2 text-light display-5 fw-bold" data-cursor="-opaque">
                        League <span class="text-primary">Standings</span>
                    </h2>
                </div>

                <div class="league-table-container">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th width="60" class="text-center">#</th>
                                    <th>Team</th>
                                    <th width="70" class="text-center">P</th>
                                    <th width="70" class="text-center">W</th>
                                    <th width="70" class="text-center">D</th>
                                    <th width="70" class="text-center">L</th>
                                    <th width="70" class="text-center">GF</th>
                                    <th width="70" class="text-center">GA</th>
                                    <th width="80" class="text-center">GD</th>
                                    <th width="90" class="text-center">Pts</th>
                                </tr>
                            </thead>
                            <tbody id="league-table-1">
                                <!-- Data loaded via AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Fixtures Column -->
        <div class="col-lg-5">
            <div class="fixtures-container">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h4 id="gw-title-1" class="text-light mb-0">Gameweek Fixtures</h4>
                        <small class="text-muted" id="gw-subtitle-1">Select a gameweek</small>
                    </div>
                    <select class="form-select w-auto gw-selector" data-division="1" style="min-width: 150px;">
                        <option>Loading...</option>
                    </select>
                </div>

                <div class="fixtures-list" id="fixtures-container-1">
                    <div class="text-center py-4">
                        <div class="spinner-border text-primary" role="status"></div>
                        <p class="mt-2 mb-0 text-muted">Loading fixtures...</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Goalscorers Section - UPDATED -->
        <div class="goalscorers-section mt-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <h3 class="text-light mb-2">
                        <i class="fas fa-futbol me-2 text-primary"></i>Top Goalscorers
                    </h3>
                    <p class="text-light mb-0" id="goalscorers-subtitle-1">Leading scorers in Division 1</p>
                </div>
                <div class="d-flex gap-2">
                    <select class="form-select w-auto goalscorer-gw-selector" data-division="1" style="min-width: 150px;">
                        <option value="0">All Gameweeks</option>
                        <!-- Gameweek options will be populated dynamically -->
                    </select>
                </div>
            </div>
            <div class="goalscorers-grid" id="goalscorers-container-1">
                <div class="text-center py-3 w-100">
                    <div class="spinner-border text-primary" role="status"></div>
                    <p class="mt-2 mb-0 text-light">Loading goalscorers...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Repeat for other divisions (initially hidden) -->
<div class="division-content championship-division" data-division="2">
    <div class="row">
        <!-- League Table Column -->
        <div class="col-lg-7 mb-4">
            <div class="our-schedule-content">
                <div class="section-title mb-4">
                    <h3 class="wow fadeInUp text-light">Division 2</h3>
                    <h2 class="text-anime-style-2 text-light display-5 fw-bold">
                        League <span class="text-primary">Standings</span>
                    </h2>
                </div>
                <div class="league-table-container">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th width="60" class="text-center">#</th>
                                    <th>Team</th>
                                    <th width="70" class="text-center">P</th>
                                    <th width="70" class="text-center">W</th>
                                    <th width="70" class="text-center">D</th>
                                    <th width="70" class="text-center">L</th>
                                    <th width="70" class="text-center">GF</th>
                                    <th width="70" class="text-center">GA</th>
                                    <th width="80" class="text-center">GD</th>
                                    <th width="90" class="text-center">Pts</th>
                                </tr>
                            </thead>
                            <tbody id="league-table-2">
                                <tr><td colspan="10" class="text-center py-4 text-muted">Select division to load data</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="fixtures-container">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h4 id="gw-title-2" class="text-light mb-0">Gameweek Fixtures</h4>
                        <small class="text-muted" id="gw-subtitle-2">Select division to load data</small>
                    </div>
                    <select class="form-select w-auto gw-selector" data-division="2" style="min-width: 150px;">
                        <option>Select division</option>
                    </select>
                </div>
                <div class="fixtures-list" id="fixtures-container-2">
                    <div class="text-center py-4 text-muted">
                        <i class="fas fa-hand-pointer fa-2x mb-3"></i>
                        <p>Select this division to view fixtures</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Goalscorers Section for Division 2 -->
        <div class="goalscorers-section mt-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <h3 class="text-light mb-2">
                        <i class="fas fa-futbol me-2 text-primary"></i>Top Goalscorers
                    </h3>
                    <p class="text-light mb-0" id="goalscorers-subtitle-2">Leading scorers in Division 2</p>
                </div>
                <div class="d-flex gap-2">
                    <select class="form-select w-auto goalscorer-gw-selector" data-division="2" style="min-width: 150px;">
                        <option value="0">All Gameweeks</option>
                    </select>
                </div>
            </div>
            <div class="goalscorers-grid" id="goalscorers-container-2">
                <div class="text-center py-4 text-muted">
                    <i class="fas fa-hand-pointer fa-2x mb-3"></i>
                    <p>Select this division to view goalscorers</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="division-content league-one-division" data-division="3">
    <div class="row">
        <!-- League Table Column -->
        <div class="col-lg-7 mb-4">
            <div class="our-schedule-content">
                <div class="section-title mb-4">
                    <h3 class="wow fadeInUp text-light">Division 3</h3>
                    <h2 class="text-anime-style-2 text-light display-5 fw-bold">
                        League <span class="text-primary">Standings</span>
                    </h2>
                </div>
                <div class="league-table-container">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th width="60" class="text-center">#</th>
                                    <th>Team</th>
                                    <th width="70" class="text-center">P</th>
                                    <th width="70" class="text-center">W</th>
                                    <th width="70" class="text-center">D</th>
                                    <th width="70" class="text-center">L</th>
                                    <th width="70" class="text-center">GF</th>
                                    <th width="70" class="text-center">GA</th>
                                    <th width="80" class="text-center">GD</th>
                                    <th width="90" class="text-center">Pts</th>
                                </tr>
                            </thead>
                            <tbody id="league-table-3">
                                <tr><td colspan="10" class="text-center py-4 text-muted">Select division to load data</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="fixtures-container">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h4 id="gw-title-3" class="text-light mb-0">Gameweek Fixtures</h4>
                        <small class="text-muted" id="gw-subtitle-3">Select division to load data</small>
                    </div>
                    <select class="form-select w-auto gw-selector" data-division="3" style="min-width: 150px;">
                        <option>Select division</option>
                    </select>
                </div>
                <div class="fixtures-list" id="fixtures-container-3">
                    <div class="text-center py-4 text-muted">
                        <i class="fas fa-hand-pointer fa-2x mb-3"></i>
                        <p>Select this division to view fixtures</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Goalscorers Section for Division 3 -->
        <div class="goalscorers-section mt-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <h3 class="text-light mb-2">
                        <i class="fas fa-futbol me-2 text-primary"></i>Top Goalscorers
                    </h3>
                    <p class="text-light mb-0" id="goalscorers-subtitle-3">Leading scorers in Division 3</p>
                </div>
                <div class="d-flex gap-2">
                    <select class="form-select w-auto goalscorer-gw-selector" data-division="3" style="min-width: 150px;">
                        <option value="0">All Gameweeks</option>
                    </select>
                </div>
            </div>
            <div class="goalscorers-grid" id="goalscorers-container-3">
                <div class="text-center py-4 text-muted">
                    <i class="fas fa-hand-pointer fa-2x mb-3"></i>
                    <p>Select this division to view goalscorers</p>
                </div>
            </div>
        </div>
    </div>
</div>
        </div>

        <?php
        $sq = $db->query("SELECT * FROM results WHERE division = 1 ORDER BY gameweek DESC LIMIT 1");
        if (mysqli_num_rows($sq) < 1) {
        ?>
            <input type="hidden" id="gw-no" value="1">
        <?php
        } else {
            $fetch = mysqli_fetch_assoc($sq); ?>
            <input type="hidden" id="gw-no" value="<?= $fetch['gameweek'] ?>">
        <?php } ?>
    </div>

    <?php include('footer.php') ?>

    <script>
        let currentDivision = 1;
        let gameweekData = {};

        // Initialize page
        $(document).ready(function() {
            // Initialize tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Load initial data for division 1
            loadDivisionData(1);
            loadGoalscorers(1);

            // Set up division tab handlers
            $('.division-tab').on('click', function() {
                const division = $(this).data('division');
                switchDivision(division);
            });

            // Auto-refresh
            // setInterval(() => refreshCurrentDivision(), 30000);
            // setInterval(loadGoalscorers, 60000);
        });

        // Update switchDivision function to handle goalscorers
       function switchDivision(division) {
    // Update active tab
    $('.division-tab').removeClass('active');
    $(`.division-tab[data-division="${division}"]`).addClass('active');

    // Update active content
    $('.division-content').removeClass('active');
    $(`.division-content[data-division="${division}"]`).addClass('active');

    // Load data if not already loaded
    if (!gameweekData[division]) {
        loadDivisionData(division);
    } else {
        updateStats(division);
        // Load goalscorers for the new division
        loadGoalscorers(division, 0); // 0 means all gameweeks
    }

    currentDivision = division;
}

        function loadDivisionData(division) {
            // Show loading states
            $(`#league-table-${division}`).html(`
                <tr><td colspan="10" class="text-center py-4">
                    <div class="spinner-border text-primary" role="status"></div>
                </td></tr>
            `);

            $(`#fixtures-container-${division}`).html(`
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status"></div>
                    <p class="mt-2 mb-0 text-muted">Loading fixtures...</p>
                </div>
            `);

            // Load league table
            refreshLeagueTable(division);

            // Load gameweeks
            loadGameweeks(division);

            loadGoalscorers(division);

            updateStats(division);
        }

        function refreshLeagueTable(division) {
            $.ajax({
                url: "admin/connect.php",
                method: "GET",
                data: {
                    refreshLeagueTable: "Yes",
                    division: division
                },
                success: function(data) {
                    renderLeagueTable(division, data);
                },
                error: function() {
                    $(`#league-table-${division}`).html(`
                        <tr><td colspan="10" class="text-center py-4 text-muted">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            Failed to load table
                        </td></tr>
                    `);
                }
            });
        }

        function renderLeagueTable(division, data) {
            let html = "";
            let pos = 1;

            data.forEach(row => {
                const goalDiff = parseInt(row.goal_difference);
                const goalDiffDisplay = goalDiff > 0 ? `+${goalDiff}` : goalDiff;

                html += `
                <tr>
                    <td class="position-cell">${pos}</td>
                    <td>
                        <div class="team-cell">
                            <img src="admin/uploads/${row.logo}" 
                                 onerror="this.src='images/icon-schedule-3.svg'" 
                                 alt="${row.team_name}" 
                                 class="team-logo-table">
                            <span>${row.team_name}</span>
                        </div>
                    </td>
                    <td class="text-center">${row.played}</td>
                    <td class="text-center">${row.won}</td>
                    <td class="text-center">${row.drawn}</td>
                    <td class="text-center">${row.lost}</td>
                    <td class="text-center">${row.goals_for}</td>
                    <td class="text-center">${row.goals_against}</td>
                    <td class="text-center fw-bold ${goalDiff >= 0 ? 'text-primary' : 'text-danger'}">${goalDiffDisplay}</td>
                    <td class="text-center fw-bold text-primary">${row.points}</td>
                </tr>`;
                pos++;
            });

            $(`#league-table-${division}`).html(html);
        }
        let gwno = $("#gw-no").val();

        function loadGameweeks(division) {
            $.ajax({
                method: "GET",
                url: "admin/connect.php",
                data: {
                    get_fixt_details: "Yes",
                    division: division
                },
                success: function(data) {
                    gameweekData[division] = data;
                    populateGameweekSelector(division, data);

                    // Load initial fixtures for current gameweek
                    const initGw = Object.keys(data)[0] || 1;

                    getResults(division, gwno);
                },
                error: function() {
                    $(`.gw-selector[data-division="${division}"]`).html('<option>Error loading</option>');
                }
            });
        }

        function populateGameweekSelector(division, data) {
    const fixtureSelect = $(`.gw-selector[data-division="${division}"]`).empty();
    const goalscorerSelect = $(`.goalscorer-gw-selector[data-division="${division}"]`).empty();

    // Add "All Gameweeks" option to goalscorer selector
    goalscorerSelect.append($("<option>").val(0).text('All Gameweeks'));

    if (Array.isArray(data)) {
        data.forEach(gw => {
            let opt = $("<option>").val(gw).text(`Gameweek ${gw}`);
            if (gw === (gwno)) opt.prop("selected", true);
            fixtureSelect.append(opt);
            goalscorerSelect.append($("<option>").val(gw).text(`Gameweek ${gw}`));
        });
    } else if (typeof data === 'object') {
        Object.keys(data).forEach(gw => {
            let opt = $("<option>").val(gw).text(`Gameweek ${gw}`);
            if (gw === (gwno)) opt.prop("selected", true);
            fixtureSelect.append(opt);
            goalscorerSelect.append($("<option>").val(gw).text(`Gameweek ${gw}`));
        });
    }

    // Set up change handler for fixture selector
    fixtureSelect.off('change').on('change', function() {
        const gw = $(this).val();
        getResults(division, gw);
    });

    // Set up change handler for goalscorer selector
    goalscorerSelect.off('change').on('change', function() {
        const gw = $(this).val();
        loadGoalscorers(division, gw);
    });
}


        function getResults(division, gw) {
            const container = $(`#fixtures-container-${division}`);

            container.html(`
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status"></div>
                    <p class="mt-2 mb-0 text-muted">Loading fixtures...</p>
                </div>
            `);

            $.ajax({
                method: "GET",
                url: "admin/connect.php",
                data: {
                    getFixturesWithResults: "YES",
                    gw: gw,
                    division: division
                },
                success: function(data) {
                    renderFixtures(division, gw, data);
                    if (division === currentDivision) {
                        updateStats(division, data);
                    }
                },
                error: function() {
                    container.html(`
                        <div class="text-center py-4">
                            <i class="fas fa-exclamation-triangle text-warning fa-2x mb-3"></i>
                            <p class="text-muted">Failed to load fixtures</p>
                        </div>
                    `);
                }
            });
        }

        function renderFixtures(division, gw, fixtures) {
            $(`#gw-title-${division}`).text(`Gameweek ${gw} Fixtures`);
            $(`#gw-subtitle-${division}`).text(`${fixtures.length} matches scheduled`);

            const container = $(`#fixtures-container-${division}`).empty();

            if (!fixtures || fixtures.length === 0) {
                container.html(`
                    <div class="text-center py-4">
                        <i class="fas fa-calendar-times text-muted fa-2x mb-3"></i>
                        <p class="text-muted">No fixtures scheduled</p>
                    </div>
                `);
                return;
            }

            fixtures.forEach(f => {
                const hasScores = f.home_goals !== null && f.away_goals !== null;
                const hasPoints = f.home_points !== null && f.away_points !== null;

                const scoreDisplay = hasScores ?
                    `${f.home_goals} - ${f.away_goals}` :
                    'VS';

                const pointsDisplay = hasPoints ?
                    `<div class="fixture-points">${f.home_points}-${f.away_points}</div>` :
                    '';

                // Status badge with better styling
                let statusBadge = "";
                if (f.status === "Closed") {
                    statusBadge = `<span class="badge badge-completed">FT</span>`;
                } else if (f.status === "Live") {
                    statusBadge = `<span class="badge badge-live">LIVE</span>`;
                } else {
                    statusBadge = `<span class="badge badge-scheduled">UPCOMING</span>`;
                }

                const fixtureCard = `
                <div class="fixture-card">
                    <div class="fixture-content">
                        <div class="fixture-team">
                            <img src="admin/uploads/${f.home_logo}" 
                                 onerror="this.src='images/icon-schedule-3.svg'" 
                                 alt="${f.home_team}" 
                                 class="team-logo-fixture">
                            <div class="team-name">${f.home_team}</div>
                        </div>
                        
                        <div class="fixture-center">
                            <div class="fixture-score">${scoreDisplay}</div>
                            ${pointsDisplay}
                        </div>
                        
                        <div class="fixture-team">
                            <img src="admin/uploads/${f.away_logo}" 
                                 onerror="this.src='images/icon-schedule-2.svg'" 
                                 alt="${f.away_team}" 
                                 class="team-logo-fixture">
                            <div class="team-name">${f.away_team}</div>
                        </div>
                    </div>
                    
                    <div class="fixture-status">
                        ${statusBadge}
                    </div>
                </div>`;

                container.append(fixtureCard);
            });
        }

       function loadGoalscorers(division, gameweek = 0) {
    const container = $(`#goalscorers-container-${division}`);
    const subtitle = $(`#goalscorers-subtitle-${division}`);

    // Update subtitle based on selection
    let gwText = gameweek === 0 ? 'All Gameweeks' : `Gameweek ${gameweek}`;
    subtitle.text(`Leading scorers in Division ${division} - ${gwText}`);

    container.html(`
        <div class="text-center py-3 w-100">
            <div class="spinner-border text-primary" role="status"></div>
            <p class="mt-2 mb-0 text-light">Loading goalscorers...</p>
        </div>
    `);

    $.ajax({
        method: "GET",
        url: "admin/connect.php",
        data: {
            getGoalscorers: "YES",
            division: division,
            gw: gameweek
        },
        success: function(data) {
            renderGoalscorers(division, data);
        },
        error: function() {
            container.html(`
                <div class="text-center py-3 w-100">
                    <i class="fas fa-exclamation-triangle text-warning fa-2x mb-3"></i>
                    <p class="text-light">Failed to load goalscorers</p>
                </div>
            `);
        }
    });
}

function renderGoalscorers(division, goalscorers) {
    const container = $(`#goalscorers-container-${division}`);

    if (!goalscorers || goalscorers.length === 0) {
        container.html(`
            <div class="text-center py-3 w-100">
                <i class="fas fa-info-circle text-light fa-2x mb-3"></i>
                <p class="text-light">No goalscorer data available for this selection</p>
            </div>
        `);
        return;
    }

    let html = '';

    goalscorers.forEach((scorer, index) => {
        // Determine rank color based on position
        let rankClass = "goalscorer-rank";
        if (index === 0) {
            rankClass += " rank-gold";
        } else if (index === 1) {
            rankClass += " rank-silver";
        } else if (index === 2) {
            rankClass += " rank-bronze";
        }

        html += `
        <div class="goalscorer-card">
            <div class="${rankClass}">${index + 1}</div>
            <div class="goalscorer-info">
                <div class="goalscorer-name">${scorer.manager_name}</div>
                <div class="goalscorer-team">
                    <img src="admin/uploads/${scorer.team_logo}" 
                         onerror="this.src='images/icon-schedule-3.svg'" 
                         alt="${scorer.manager_team}" 
                         style="width: 16px; height: 16px; border-radius: 3px;">
                    ${scorer.manager_team}
                </div>
            </div>
            <div class="goalscorer-stats">
                <div class="goalscorer-goals mb-2">${scorer.goals}</div>
                <div class="goalscorer-label">Goals</div>
                ${scorer.points ? `<div class="goalscorer-points text-muted" style="font-size: 0.8em;">${scorer.points} pts</div>` : ''}
            </div>
        </div>`;
    });

    container.html(html);
}


        function updateStats(division, fixtures) {
            if (!fixtures) return;

            const totalMatches = fixtures.length;
            const liveMatches = fixtures.filter(f => f.status === "Live").length;
            const totalGoals = fixtures.reduce((sum, f) => sum + ((f.home_goals * 1) || 0) + ((f.away_goals * 1) || 0), 0);

            $("#total-matches").text(totalMatches);
            $("#live-matches").text(liveMatches);
            $("#total-goals").text(totalGoals);
            $("#total-teams").text("20"); // Assuming 20 teams per division
        }

        function refreshCurrentDivision() {
            refreshLeagueTable(currentDivision);

            // Also refresh fixtures for current gameweek
            const currentGw = $(`.gw-selector[data-division="${currentDivision}"]`).val();
            if (currentGw) {
                getResults(currentDivision, currentGw);
            }
        }

        // Initialize all divisions on page load
        function initializeAllDivisions() {
            [1, 2, 3].forEach(division => {
                // Create empty content containers for divisions 2 and 3
                if (division > 1) {
                    $(`.division-content[data-division="${division}"]`).html(`
                        <div class="row">
                            <div class="col-lg-7 mb-4">
                                <div class="our-schedule-content">
                                    <div class="section-title mb-4">
                                        <h3 class="wow fadeInUp text-light">${division === 2 ? 'Division 2' : 'Division 3'}</h3>
                                        <h2 class="text-anime-style-2 text-light display-5 fw-bold">
                                            League <span class="text-primary">Standings</span>
                                        </h2>
                                    </div>
                                    <div class="league-table-container">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th width="60" class="text-center">#</th>
                                                        <th>Team</th>
                                                        <th width="70" class="text-center">P</th>
                                                        <th width="70" class="text-center">W</th>
                                                        <th width="70" class="text-center">D</th>
                                                        <th width="70" class="text-center">L</th>
                                                        <th width="70" class="text-center">GF</th>
                                                        <th width="70" class="text-center">GA</th>
                                                        <th width="80" class="text-center">GD</th>
                                                        <th width="90" class="text-center">Pts</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="league-table-${division}">
                                                    <tr><td colspan="10" class="text-center py-4 text-muted">Select division to load data</td></tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-5">
                                <div class="fixtures-container">
                                    <div class="d-flex justify-content-between align-items-center mb-4">
                                        <div>
                                            <h4 id="gw-title-${division}" class="text-light mb-0">Gameweek Fixtures</h4>
                                            <small class="text-muted" id="gw-subtitle-${division}">Select division to load data</small>
                                        </div>
                                        <select class="form-select w-auto gw-selector" data-division="${division}" style="min-width: 150px;">
                                            <option>Select division</option>
                                        </select>
                                    </div>
                                    <div class="fixtures-list" id="fixtures-container-${division}">
                                        <div class="text-center py-4 text-muted">
                                            <i class="fas fa-hand-pointer fa-2x mb-3"></i>
                                            <p>Select this division to view fixtures</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `);
                }
            });
        }

        // Call this at the end of document ready
        // initializeAllDivisions();
    </script>
</body>

</html>