<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>User Management | FPL Maestros</title>
    <?php 
    include('nav.php'); ?>
    <style>
        /* Mobile-first responsive styles */
        .mobile-card {
            display: none;
        }
        
        .table-actions {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
        }
        
        .table-actions .btn {
            flex: 1;
            min-width: 80px;
            font-size: 0.875rem;
        }
        
        /* Responsive table container */
        .table-responsive-custom {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        /* Mobile card styles */
        .user-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .user-card.hidden {
            display: none;
        }
        
        .user-card-header {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
            gap: 0.75rem;
        }
        
        .user-avatar {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 1.2rem;
        }
        
        .user-info {
            flex: 1;
        }
        
        .user-name {
            font-weight: 600;
            font-size: 1.1rem;
            color: #333;
            margin: 0 0 0.25rem 0;
        }
        
        .user-username {
            color: #666;
            font-size: 0.9rem;
            margin: 0;
        }
        
        .user-details {
            display: grid;
            gap: 0.75rem;
        }
        
        .user-detail-item {
            padding: 0.5rem 0;
            border-bottom: 1px solid #f5f5f5;
        }
        
        .user-detail-label {
            font-weight: 500;
            color: #666;
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }
        
        .user-detail-value {
            color: #333;
            font-size: 0.9rem;
        }
        
        /* Search Bar Styles */
        .search-container {
            margin-bottom: 1.5rem;
        }
        
        .search-box {
            position: relative;
            max-width: 400px;
        }
        
        .search-box .form-control {
            padding-left: 2.5rem;
            min-height: 48px;
        }
        
        .search-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
            z-index: 5;
        }
        
        .no-results {
            text-align: center;
            padding: 3rem 1rem;
            color: #6c757d;
        }
        
        /* Modal responsive adjustments */
        @media (max-width: 576px) {
            .modal-dialog {
                margin: 0.5rem;
            }
            
            .modal-content {
                border-radius: 8px;
            }
            
            .modal-body {
                padding: 1rem;
            }
            
            .btn-group-responsive {
                display: flex;
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .btn-group-responsive .btn {
                width: 100%;
            }
            
            .search-box {
                max-width: 100%;
            }
        }
        
        /* Show mobile cards and hide table on small screens */
        @media (max-width: 768px) {
            .desktop-table {
                display: none;
            }
            
            .mobile-card {
                display: block;
            }
            
            .card-header {
                flex-direction: column;
                gap: 1rem;
                align-items: flex-start !important;
            }
            
            .card-header .btn {
                width: 100%;
            }
        }
        
        /* Ensure buttons are touch-friendly */
        .btn {
            min-height: 44px;
            padding: 0.5rem 1rem;
        }
        
        /* DataTable mobile optimizations */
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            padding: 0.5rem 0.75rem;
            margin: 0 0.125rem;
            min-width: 44px;
            min-height: 44px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Floating action button */
        .add-user-container {
            position: fixed;
            bottom: 2rem;
            right: 2rem;
            z-index: 1000;
        }
        
        @media (max-width: 768px) {
            .add-user-container {
                bottom: 1rem;
                right: 1rem;
            }
        }
        
        /* Password strength indicator */
        .password-strength {
            height: 4px;
            border-radius: 2px;
            margin-top: 0.25rem;
            transition: all 0.3s ease;
        }
        
        .strength-weak { background: #dc3545; width: 25%; }
        .strength-fair { background: #ffc107; width: 50%; }
        .strength-good { background: #17a2b8; width: 75%; }
        .strength-strong { background: #28a745; width: 100%; }
        
        .password-feedback {
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }
    </style>

    <?php 
    // include('nav.php');
    
    // Check if user is logged in (you can add role checking if needed)
    // session_start();
    // if (!isset($_SESSION['user_id'])) {
    //     header('Location: login.php');
    //     exit();
    // }
    
    // Database connection
    require_once 'connect.php';
    
    // Handle form submissions
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['add_user'])) {
            // Add new user
            $name = $db->real_escape_string($_POST['name']);
            $username = $db->real_escape_string($_POST['username']);
            $email = $db->real_escape_string($_POST['email']);
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            
            $sql = "INSERT INTO users (name, username, email, password, created_at) 
                    VALUES ('$name', '$username', '$email', '$password', NOW())";
            
            if ($db->query($sql)) {
                $success_message = "User added successfully!";
            } else {
                $error_message = "Error adding user: " . $db->error;
            }
        }
        elseif (isset($_POST['update_user'])) {
            // Update user
            $user_id = $db->real_escape_string($_POST['user_id']);
            $name = $db->real_escape_string($_POST['name']);
            $username = $db->real_escape_string($_POST['username']);
            $email = $db->real_escape_string($_POST['email']);
            
            $sql = "UPDATE users SET name='$name', username='$username', email='$email' WHERE id='$user_id'";
            
            if ($db->query($sql)) {
                $success_message = "User updated successfully!";
            } else {
                $error_message = "Error updating user: " . $db->error;
            }
        }
        elseif (isset($_POST['delete_user'])) {
            // Delete user (prevent self-deletion)
            $user_id = $db->real_escape_string($_POST['user_id']);
            
            if ($user_id == $_SESSION['user_id']) {
                $error_message = "You cannot delete your own account!";
            } else {
                $sql = "DELETE FROM users WHERE id='$user_id'";
                if ($db->query($sql)) {
                    $success_message = "User deleted successfully!";
                } else {
                    $error_message = "Error deleting user: " . $db->error;
                }
            }
        }
        elseif (isset($_POST['change_password'])) {
            // Change current user's password
            $current_password = $_POST['current_password'];
            $new_password = $_POST['new_password'];
            $confirm_password = $_POST['confirm_password'];
            
            // Verify current password
            $user_id = $_SESSION['user_id'];
            $result = $db->query("SELECT password FROM users WHERE id='$user_id'");
            $user = $result->fetch_assoc();
            
            if (password_verify($current_password, $user['password'])) {
                if ($new_password === $confirm_password) {
                    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                    $sql = "UPDATE users SET password='$hashed_password' WHERE id='$user_id'";
                    
                    if ($db->query($sql)) {
                        $success_message = "Password changed successfully!";
                    } else {
                        $error_message = "Error changing password: " . $db->error;
                    }
                } else {
                    $error_message = "New passwords do not match!";
                }
            } else {
                $error_message = "Current password is incorrect!";
            }
        }
    }
    
    // Fetch all users
    $users_result = $db->query("SELECT * FROM users ORDER BY name ASC");
    ?>

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            
            <!-- Page Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0">User Management</h4>
                            <p class="text-muted mt-2">Manage system users</p>
                        </div>
                        <div class="d-flex gap-2">
                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                                <i class="ri-lock-password-line me-2"></i>Change Password
                            </button>
                            <!-- <button class="btn btn-primary d-none d-md-inline-flex" data-bs-toggle="modal" data-bs-target="#addUserModal">
                                <i class="ri-user-add-line me-2"></i>Add User
                            </button> -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Alert Messages -->
            <?php if (isset($success_message)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="ri-check-line me-2"></i><?= $success_message ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="ri-error-warning-line me-2"></i><?= $error_message ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <!-- Search Bar -->
            <!-- <div class="search-container">
                <div class="search-box">
                    <i class="ri-search-line search-icon"></i>
                    <input type="text" id="userSearch" class="form-control" placeholder="Search users by name, username, or email..." />
                </div>
            </div> -->

            <!-- Mobile Cards View -->
            <div class="mobile-card">
                <div id="mobileUsersContainer">
                    <?php while ($user = $users_result->fetch_assoc()): ?>
                        <div class="user-card" data-name="<?= htmlspecialchars(strtolower($user['name'])) ?>" 
                             data-username="<?= htmlspecialchars(strtolower($user['username'])) ?>" 
                             data-email="<?= htmlspecialchars(strtolower($user['email'])) ?>">
                            <div class="user-card-header">
                                <div class="user-avatar">
                                    <?= strtoupper(substr($user['name'], 0, 1)) ?>
                                </div>
                                <div class="user-info">
                                    <h3 class="user-name"><?= htmlspecialchars($user['name']) ?></h3>
                                    <p class="user-username">@<?= htmlspecialchars($user['username']) ?></p>
                                </div>
                            </div>
                            
                            <div class="user-details">
                                <div class="user-detail-item">
                                    <div class="user-detail-label">Email</div>
                                    <div class="user-detail-value"><?= htmlspecialchars($user['email']) ?></div>
                                </div>
                                
                                <div class="user-detail-item">
                                    <div class="user-detail-label">Username</div>
                                    <div class="user-detail-value"><?= htmlspecialchars($user['username']) ?></div>
                                </div>
                                
                                <?php if (isset($user['created_at'])): ?>
                                <div class="user-detail-item">
                                    <div class="user-detail-label">Created</div>
                                    <div class="user-detail-value"><?= date('M j, Y', strtotime($user['created_at'])) ?></div>
                                </div>
                                <?php endif; ?>
                                
                                <div class="user-detail-item">
                                    <div class="user-detail-label">Actions</div>
                                    <div class="btn-group-responsive mt-2">
                                        <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal<?= $user['id'] ?>">
                                            Edit User
                                        </button>
                                        <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                            <form method="POST" class="d-inline w-100">
                                                <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                                <button class="btn btn-outline-danger btn-sm w-100 mt-1" name="delete_user" onclick="return confirm('Are you sure you want to delete <?= htmlspecialchars($user['name']) ?>?')">
                                                    Delete User
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <button class="btn btn-outline-secondary btn-sm w-100 mt-1" disabled>
                                                Cannot Delete Self
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    
                    <!-- No results message -->
                    <div id="noResultsMobile" class="no-results" style="display: none;">
                        <i class="ri-search-line ri-3x mb-3"></i>
                        <h5>No users found</h5>
                        <p class="text-muted">Try adjusting your search terms</p>
                    </div>
                </div>
            </div>

            <!-- Desktop Table View -->
            <div class="card desktop-table">
                <div class="card-header border-bottom d-flex align-items-center">
                    <h5 class="card-title mb-0">All Users</h5>
                    <button class="btn btn-primary ms-auto" data-bs-toggle="modal" data-bs-target="#addUserModal">
                        <i class="ri-user-add-line me-2"></i>Add User
                    </button>
                </div>
                <div class="card-datatable">
                    <div class="table-responsive-custom">
                        <table class="table table-hover" id="usersTable">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Username</th>
                                    <th>Email</th>
                                    <th>Created</th>
                                    <th width="200">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                // Reset pointer and loop again for table
                                $users_result->data_seek(0);
                                while ($user = $users_result->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="user-avatar me-3">
                                                    <?= strtoupper(substr($user['name'], 0, 1)) ?>
                                                </div>
                                                <div>
                                                    <strong><?= htmlspecialchars($user['name']) ?></strong>
                                                </div>
                                            </div>
                                        </td>
                                        <td>@<?= htmlspecialchars($user['username']) ?></td>
                                        <td><?= htmlspecialchars($user['email']) ?></td>
                                        <td>
                                            <?php if (isset($user['created_at'])): ?>
                                                <?= date('M j, Y', strtotime($user['created_at'])) ?>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="table-actions">
                                                <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal<?= $user['id'] ?>">
                                                    <i class="ri-edit-line me-1"></i>Edit
                                                </button>
                                                <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                                    <form method="POST" class="d-inline">
                                                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                                        <button class="btn btn-outline-danger btn-sm" name="delete_user" onclick="return confirm('Are you sure you want to delete <?= htmlspecialchars($user['name']) ?>?')">
                                                            <i class="ri-delete-bin-line me-1"></i>Delete
                                                        </button>
                                                    </form>
                                                <?php else: ?>
                                                    <button class="btn btn-outline-secondary btn-sm" disabled>
                                                        <i class="ri-user-line me-1"></i>Self
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Floating Action Button for Mobile -->
            <div class="add-user-container d-md-none">
                <button class="btn btn-primary rounded-circle shadow-lg" data-bs-toggle="modal" data-bs-target="#addUserModal" style="width: 60px; height: 60px;">
                    <i class="ri-user-add-line ri-lg"></i>
                </button>
            </div>

            <!-- Add User Modal -->
            <div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Add New User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST" id="addUserForm">
                                <div class="row g-3">
                                    <div class="col-12 col-md-6">
                                        <label for="name" class="form-label">Full Name</label>
                                        <input type="text" id="name" class="form-control" placeholder="Enter full name" name="name" required />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label for="username" class="form-label">Username</label>
                                        <input type="text" id="username" class="form-control" placeholder="Enter username" name="username" required />
                                    </div>
                                    <div class="col-12">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" id="email" class="form-control" placeholder="Enter email" name="email" required />
                                    </div>
                                    <div class="col-12">
                                        <label for="password" class="form-label">Password</label>
                                        <input type="password" id="password" class="form-control" placeholder="Enter password" name="password" required />
                                        <div class="password-strength" id="passwordStrength"></div>
                                        <div class="password-feedback" id="passwordFeedback"></div>
                                    </div>
                                    <div class="col-12 mt-4">
                                        <div class="d-flex gap-2">
                                            <button type="submit" class="btn btn-primary flex-fill" name="add_user">Add User</button>
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Change Password Modal -->
            <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Change Your Password</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST">
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="current_password" class="form-label">Current Password</label>
                                        <input type="password" id="current_password" class="form-control" placeholder="Enter current password" name="current_password" required />
                                    </div>
                                    <div class="col-12">
                                        <label for="new_password" class="form-label">New Password</label>
                                        <input type="password" id="new_password" class="form-control" placeholder="Enter new password" name="new_password" required />
                                    </div>
                                    <div class="col-12">
                                        <label for="confirm_password" class="form-label">Confirm New Password</label>
                                        <input type="password" id="confirm_password" class="form-control" placeholder="Confirm new password" name="confirm_password" required />
                                    </div>
                                    <div class="col-12 mt-4">
                                        <div class="d-flex gap-2">
                                            <button type="submit" class="btn btn-primary flex-fill" name="change_password">Change Password</button>
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Edit User Modals -->
            <?php
            $users_result->data_seek(0);
            while ($user = $users_result->fetch_assoc()):
            ?>
                <div class="modal fade" id="editUserModal<?= $user['id'] ?>" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Edit User: <?= htmlspecialchars($user['name']) ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form method="POST">
                                    <div class="row g-3">
                                        <div class="col-12 col-md-6">
                                            <label for="name<?= $user['id'] ?>" class="form-label">Full Name</label>
                                            <input type="text" id="name<?= $user['id'] ?>" class="form-control" placeholder="Full Name" name="name" value="<?= htmlspecialchars($user['name']) ?>" required />
                                            <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label for="username<?= $user['id'] ?>" class="form-label">Username</label>
                                            <input type="text" id="username<?= $user['id'] ?>" class="form-control" placeholder="Username" name="username" value="<?= htmlspecialchars($user['username']) ?>" required />
                                        </div>
                                        <div class="col-12">
                                            <label for="email<?= $user['id'] ?>" class="form-label">Email</label>
                                            <input type="email" id="email<?= $user['id'] ?>" class="form-control" placeholder="Email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required />
                                        </div>
                                        <div class="col-12 mt-4">
                                            <div class="d-flex gap-2">
                                                <button type="submit" class="btn btn-primary flex-fill" name="update_user">Update User</button>
                                                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>

        </div>
        <!-- / Content -->
    </div>

    <?php include('footer.php') ?>
    
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            var table = $('#usersTable').DataTable({
                pageLength: 10,
                lengthChange: true,
                ordering: true,
                searching: true,
                responsive: true,
                language: {
                    search: "Search users:",
                    lengthMenu: "Show _MENU_ users",
                    info: "Showing _START_ to _END_ of _TOTAL_ users",
                    paginate: {
                        previous: "‹",
                        next: "›"
                    }
                },
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>'
            });
            
            // Custom search functionality for both desktop and mobile
            $('#userSearch').on('input', function() {
                var searchTerm = $(this).val().toLowerCase().trim();
                
                // Update DataTable search (for desktop)
                table.search(searchTerm).draw();
                
                // Update mobile cards visibility
                filterMobileCards(searchTerm);
            });
            
            function filterMobileCards(searchTerm) {
                var visibleCount = 0;
                var $cards = $('.user-card');
                var $noResults = $('#noResultsMobile');
                
                if (searchTerm === '') {
                    $cards.removeClass('hidden');
                    $noResults.hide();
                    return;
                }
                
                $cards.each(function() {
                    var $card = $(this);
                    var name = $card.data('name');
                    var username = $card.data('username');
                    var email = $card.data('email');
                    
                    var matches = name.includes(searchTerm) ||
                                 username.includes(searchTerm) ||
                                 email.includes(searchTerm);
                    
                    if (matches) {
                        $card.removeClass('hidden');
                        visibleCount++;
                    } else {
                        $card.addClass('hidden');
                    }
                });
                
                if (visibleCount === 0) {
                    $noResults.show();
                } else {
                    $noResults.hide();
                }
            }
            
            // Password strength indicator
            $('#password').on('input', function() {
                var password = $(this).val();
                var strength = calculatePasswordStrength(password);
                var $strengthBar = $('#passwordStrength');
                var $feedback = $('#passwordFeedback');
                
                $strengthBar.removeClass('strength-weak strength-fair strength-good strength-strong');
                
                if (password.length === 0) {
                    $strengthBar.css('width', '0');
                    $feedback.text('');
                    return;
                }
                
                switch(strength.level) {
                    case 'weak':
                        $strengthBar.addClass('strength-weak');
                        $feedback.text('Password is weak').css('color', '#dc3545');
                        break;
                    case 'fair':
                        $strengthBar.addClass('strength-fair');
                        $feedback.text('Password is fair').css('color', '#ffc107');
                        break;
                    case 'good':
                        $strengthBar.addClass('strength-good');
                        $feedback.text('Password is good').css('color', '#17a2b8');
                        break;
                    case 'strong':
                        $strengthBar.addClass('strength-strong');
                        $feedback.text('Password is strong').css('color', '#28a745');
                        break;
                }
            });
            
            function calculatePasswordStrength(password) {
                var score = 0;
                
                if (password.length >= 8) score++;
                if (password.length >= 12) score++;
                if (/[a-z]/.test(password)) score++;
                if (/[A-Z]/.test(password)) score++;
                if (/[0-9]/.test(password)) score++;
                if (/[^a-zA-Z0-9]/.test(password)) score++;
                
                if (score <= 2) return { level: 'weak', score: score };
                if (score <= 3) return { level: 'fair', score: score };
                if (score <= 5) return { level: 'good', score: score };
                return { level: 'strong', score: score };
            }
            
            // Enhanced delete confirmation
            $('form').on('submit', function(e) {
                if ($(this).find('button[name="delete_user"]').length > 0) {
                    const name = $(this).closest('tr').find('td:nth-child(1) strong').text() || 
                               $(this).closest('.user-card').find('.user-name').text();
                    if (!confirm('Are you sure you want to delete user "' + name + '"? This action cannot be undone.')) {
                        e.preventDefault();
                        return false;
                    }
                }
            });
            
            // Touch-friendly enhancements
            $('.btn').on('touchstart', function() {
                $(this).addClass('btn-touch');
            });
            
            $('.btn').on('touchend', function() {
                $(this).removeClass('btn-touch');
            });
        });
    </script>
</body>
</html>