<?php
include('connect.php'); // your DB connection

function buildLeagueTable($current_gameweek) {
    global $db;
    // Clear temporary standings
    $db->query("TRUNCATE TABLE league_table");

    $sql = "SELECT * FROM results 
            WHERE gameweek <= $current_gameweek 
            AND status IN ('in_progress','finished')";
    $res = $db->query($sql);

    while ($row = $res->fetch_assoc()) {
        $home_id = $row['home_team'];
        $away_id = $row['away_team'];
        $hs = $row['home_score'];
        $as = $row['away_score'];

        // Insert or update home
        $db->query("INSERT INTO league_table 
            (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points)
            VALUES ($home_id,1,$hs,$as,$hs-$as,0,0,0,0)
            ON DUPLICATE KEY UPDATE 
                played=played+1,
                goals_for=goals_for+$hs,
                goals_against=goals_against+$as,
                goal_difference=goals_for-goals_against");

        // Insert or update away
        $db->query("INSERT INTO league_table 
            (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points)
            VALUES ($away_id,1,$as,$hs,$as-$hs,0,0,0,0)
            ON DUPLICATE KEY UPDATE 
                played=played+1,
                goals_for=goals_for+$as,
                goals_against=goals_against+$hs,
                goal_difference=goals_for-goals_against");

        // Apply result if match active
        if ($hs > $as) {
            $db->query("UPDATE league_table SET won=won+1, points=points+3 WHERE team_id=$home_id");
            $db->query("UPDATE league_table SET lost=lost+1 WHERE team_id=$away_id");
        } elseif ($hs < $as) {
            $db->query("UPDATE league_table SET won=won+1, points=points+3 WHERE team_id=$away_id");
            $db->query("UPDATE league_table SET lost=lost+1 WHERE team_id=$home_id");
        } else {
            $db->query("UPDATE league_table SET drawn=drawn+1, points=points+1 WHERE team_id IN ($home_id,$away_id)");
        }
    }
}


