<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact " dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Teams | FPL Maestros</title>


    <?php include('nav.php') ?>



    <!-- Content wrapper -->
    <div class="content-wrapper">

        <!-- Content -->

        <div class="container-xxl flex-grow-1 container-p-y">



            <!-- <div class="row g-6 mb-6">
                <div class="col-sm-6 col-xl-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="me-1">
                                    <p class="text-heading mb-1">Session</p>
                                    <div class="d-flex align-items-center">
                                        <h4 class="mb-1 me-2">21,459</h4>
                                        <p class="text-success mb-1">(+29%)</p>
                                    </div>
                                    <small class="mb-0">Total Users</small>
                                </div>
                                <div class="avatar">
                                    <div class="avatar-initial bg-label-primary rounded">
                                        <div class="ri-group-line ri-26px"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="me-1">
                                    <p class="text-heading mb-1">Paid Users</p>
                                    <div class="d-flex align-items-center">
                                        <h4 class="mb-1 me-2">4,567</h4>
                                        <p class="text-success mb-1">(+18%)</p>
                                    </div>
                                    <small class="mb-0">Last week analytics</small>
                                </div>
                                <div class="avatar">
                                    <div class="avatar-initial bg-label-danger rounded">
                                        <div class="ri-user-add-line ri-26px scaleX-n1"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="me-1">
                                    <p class="text-heading mb-1">Active Users</p>
                                    <div class="d-flex align-items-center">
                                        <h4 class="mb-1 me-2">19,860</h4>
                                        <p class="text-danger mb-1">(-14%)</p>
                                    </div>
                                    <small class="mb-0">Last week analytics</small>
                                </div>
                                <div class="avatar">
                                    <div class="avatar-initial bg-label-success rounded">
                                        <div class="ri-user-follow-line ri-26px"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="me-1">
                                    <p class="text-heading mb-1">Pending Users</p>
                                    <div class="d-flex align-items-center">
                                        <h4 class="mb-1 me-2">237</h4>
                                        <p class="text-success mb-1">(+42%)</p>
                                    </div>
                                    <small class="mb-0">Last week analytics</small>
                                </div>
                                <div class="avatar">
                                    <div class="avatar-initial bg-label-warning rounded">
                                        <div class="ri-user-search-line ri-26px"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div> -->
            <!-- Users List Table -->
            <div class="card">
                <div class="card-header border-bottom d-flex align-items-center">
                    <h6 class="card-title mb-0">Filters</h6>
                    <button class="btn btn-primary ms-auto" data-bs-toggle="modal" data-bs-target="#addTeam">Add Team</button>
                    <div class="d-flex justify-content-end align-items-right row pt-4 pb-2 gap-4 gap-md-0 gx-5">
                        <div class="col-md-4 user_role"></div>
                        <div class="col-md-4 user_plan"></div>
                        <div class="col-md-4 user_status"></div>
                    </div>
                </div>
                <div class="card-datatable table-responsive">
                    <table class="table" id="teamsTable">
                        <thead>
                            <tr>
                                <th>Division</th>
                                <th>Logo</th>
                                <th>Team Name</th>
                                <th>Managers</th>
                                <th>Captain</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sql = $db->query("SELECT * FROM teams ORDER BY team_name ASC");
                            while ($row = mysqli_fetch_assoc($sql)) {
                            ?>
                                <tr>
                                    <td><?= $row['division'] ?></td>
                                    <td><img class="" src="uploads/<?= $row['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="avatar" style="height: 48px; width: 40px; object-fit: contain;" /></td>
                                    <td><?= $row['team_name'] ?></td>
                                    <td><?= getFplTeamNameFromDb($row['manager1']) ?>, <?= getFplTeamNameFromDb($row['manager2']) ?>, <?= getFplTeamNameFromDb($row['manager3']) ?>, <?= getFplTeamNameFromDb($row['manager4']) ?>, <?= getFplTeamNameFromDb($row['manager5']) ?></td>
                                    <td><span class="badge bg-primary"><?= getFplTeamNameFromDb($row['manager1']) ?></span></td>
                                    <td>
                                        <form method="POST"><button type="button" class="btn btn-primary mx-3" data-bs-toggle="modal" data-bs-target="#editTeam<?= $row['id'] ?>">Edit</button><input type="hidden" name="id" value="<?= $row['id'] ?>"><button class="btn btn-danger" name="delete_team" onclick="if (confirm('Are you sure you want to delete?')){}else{return false}">Delete</button></form>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- Offcanvas to add new user -->
                <div class="modal fade" id="addTeam" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
                        <div class="modal-content">
                            <div class="modal-body p-0">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                <div class="text-center mb-6">
                                    <h4 class="mb-2">Add Team</h4>
                                </div>
                                <form class="row g-5" method="POST" enctype="multipart/form-data">
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" id="team_name" class="form-control" placeholder="Team Name" name="team_name" />
                                            <label for="Team Name">Team Name</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <input type="file" id="logo" class="form-control" name="logo" />
                                            <label for="logo">Team Badge</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <select name="division" class="form-control">
                                                <option selected disabled>Select Division</option>
                                                <option value="1">Division 1</option>
                                                <option value="2">Division 2</option>
                                                <option value="3">Division 3</option>
                                            </select>
                                            <label for="Select Division">Select Division</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label for="Enter 5 FPL IDs">Enter 5 FPL IDs (The captain would be the first ID inputted)</label>
                                        <div class="form-floating form-floating-outline">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 1" required>
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 2" required>
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 3" required>
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 4" required>
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 5" required>
                                            
                                        </div>
                                    </div>
                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary me-3" name="add_team">Submit</button>
                                        <button type="reset" class="btn btn-outline-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>




                <?php
                $query = $db->query("SELECT * FROM teams");
                while ($row = mysqli_fetch_assoc($query)) {
                ?>
                    <div class="modal fade" id="editTeam<?= $row['id'] ?>" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
                            <div class="modal-content">
                                <div class="modal-body p-0">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    <div class="text-center mb-6">
                                        <h4 class="mb-2">Edit Team</h4>
                                    </div>
                                     <form class="row g-5" method="POST" enctype="multipart/form-data">
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" id="team_name" class="form-control" placeholder="Team Name" name="team_name" value="<?= $row['team_name'] ?>"/>
                                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                            <label for="Team Name">Team Name</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <input type="file" id="logo" class="form-control" name="logo" />
                                            <label for="logo">Team Badge</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <select class="form-control">
                                                <option selected disabled value="<?= $row['division'] ?>">Division <?= $row['division'] ?></option>
                                                <label for="Select Division">Select Division</label>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label for="Enter 5 FPL IDs">Enter 5 FPL IDs (The captain would be the first ID inputted)</label>
                                        <div class="form-floating form-floating-outline">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 1" required value="<?= $row['manager1'] ?>">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 2" required value="<?= $row['manager2'] ?>">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 3" required value="<?= $row['manager3'] ?>">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 4" required value="<?= $row['manager4'] ?>">
                                            <input type="number" class="form-control mb-2" name="fpl_ids[]" placeholder="FPL ID 5" required value="<?= $row['manager5'] ?>">
                                            
                                        </div>
                                    </div>
                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary me-3" name="update_team">Submit</button>
                                        <button type="reset" class="btn btn-outline-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                    </div>
                                </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>


        </div>
        <!-- / Content -->


        <?php include('footer.php') ?>
        <script>
      $(document).ready(function() {
        $('#teamsTable').DataTable({
          pageLength: 10,
          lengthChange: true,
          ordering: true,
          searching: true
        });
      });
    </script>
        </body>

</html>