<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact " dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Settings | FPL Maestros</title>


    <?php include('nav.php') ?>



    <!-- Content wrapper -->
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container py-5">
            <div id="error-message"></div>
            <h2 class="mb-4">Scoring Rules Settings</h2>
            <form id="settingsForm" method="POST">

                <!-- A. Goal Conversion Rules -->
                <div class="card mb-4">
                    <div class="card-header fw-bold">Goal Conversion Rules</div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle" id="goalRulesTable">
                                <thead>
                                    <tr>
                                        <th>Min Points</th>
                                        <th>Max Points</th>
                                        <th>Goals</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = $db->query("SELECT * FROM goal_rules");
                                    while ($row = mysqli_fetch_assoc($sql)) {
                                    ?>
                                        <tr>
                                            <td><input type="number" class="form-control" name="min_points[]" value="<?= $row['min_points'] ?>" required></td>
                                            <td><input type="number" class="form-control" name="max_points[]" value="<?= $row['max_points'] ?>" required></td>
                                            <td><input type="number" class="form-control" name="goals[]" value="<?= $row['goals'] ?>" required></td>
                                            <td><button type="button" class="btn btn-danger btn-sm remove-row">Remove</button></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <button type="button" class="btn btn-outline-primary my-2" id="addGoalRule">+ Add Row</button>
                    </div>
                </div>
                <?php
                $sqlxx = $db->query("SELECT * FROM settings");
                $fetch = mysqli_fetch_assoc($sqlxx);
                ?>
                <!-- B. Tie-Break Rules -->
                <div class="card mb-4">
                    <div class="card-header fw-bold">Tie-Break Rules</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Draw if teams in different goal bands and margin ≤</label>
                            <input type="number" class="form-control" id="diff_band_margin" value="<?= $fetch['diff_band_margin'] ?>" name="diffBandMargin">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Draw if same band and margin ≤</label>
                            <input type="number" class="form-control" id="same_band_margin" value="<?= $fetch['same_band_margin'] ?>" name="sameBandMargin">
                        </div>
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" id="extra_goal_enabled">
                            <label class="form-check-label" for="extraGoalToggle">Extra goal if same band and margin greater than</label>
                        </div>
                        <input type="number" class="form-control w-25" id="extra_goal_margin" value="<?= $fetch['extra_goal_margin'] ?>" name="extraGoalMargin">
                    </div>
                </div>

                <!-- C. Low-Scoring Adjustment -->
                <!-- <div class="card mb-4">
                    <div class="card-header fw-bold">Low-Scoring Adjustment</div>
                    <div class="card-body">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" id="low_scoring_enabled">
                            <label class="form-check-label" for="low_scoring_enabled">Enable Low-Scoring Adjustment</label>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Threshold (% of teams under 200 pts)</label>
                            <input type="number" class="form-control" value="<?= $fetch['low_score_threshold'] ?>" id="low_score_threshold" name="low_score_rules">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Rules</label>
                            <div class="table-responsive">
                                <table class="table table-bordered align-middle" id="goalRulesTable2">
                                    <thead>
                                        <tr>
                                            <th>Min Points</th>
                                            <th>Max Points</th>
                                            <th>Goals</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = $db->query("SELECT * FROM low_goal_rules");
                                        while ($row = mysqli_fetch_assoc($sql)) {
                                        ?>
                                            <tr>
                                                <td><input type="number" class="form-control" name="min_points2[]" value="<?= $row['min_points'] ?>" required></td>
                                                <td><input type="number" class="form-control" name="max_points2[]" value="<?= $row['max_points'] ?>" required></td>
                                                <td><input type="number" class="form-control" name="goals2[]" value="<?= $row['goals'] ?>" required></td>
                                                <td><button type="button" class="btn btn-danger btn-sm remove-row2">Remove</button></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <button type="button" class="btn btn-outline-primary my-2" id="addGoalRule2">+ Add Row</button>
                        </div>
                    </div>
                </div> -->


                <!-- E. Save Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-success">Save Rules</button>
                </div>
            </form>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script>
            // Add new row for Goal Conversion
            document.getElementById('addGoalRule').addEventListener('click', () => {
                const tableBody = document.querySelector('#goalRulesTable tbody');
                const row = document.createElement('tr');
                row.innerHTML = `
        <td><input type="number" class="form-control" name="min_points[]" required></td>
        <td><input type="number" class="form-control"  name="max_points[]" required></td>
        <td><input type="number" class="form-control" name="goals[]" required></td>
        <td><button type="button" class="btn btn-danger btn-sm remove-row2">Remove</button></td>
      `;
                tableBody.appendChild(row);
            });

             document.getElementById('addGoalRule2').addEventListener('click', () => {
                const tableBody = document.querySelector('#goalRulesTable2 tbody');
                const row = document.createElement('tr');
                row.innerHTML = `
        <td><input type="number" class="form-control" name="min_points2[]" required></td>
        <td><input type="number" class="form-control"  name="max_points2[]" required></td>
        <td><input type="number" class="form-control" name="goals2[]" required></td>
        <td><button type="button" class="btn btn-danger btn-sm remove-row">Remove</button></td>
      `;
                tableBody.appendChild(row);
            });

            // Remove row
            document.addEventListener('click', (e) => {
                if (e.target.classList.contains('remove-row')) {
                    e.target.closest('tr').remove();
                }
            });

            document.addEventListener('click', (e) => {
                if (e.target.classList.contains('remove-row2')) {
                    e.target.closest('tr').remove();
                }
            });



            $("#settingsForm").on("submit", function(e) {
                e.preventDefault();

                // Goal rules
                let goalRules = [];
                $("tr").each(function() {
                    let min = $(this).find("input[name='min_points[]']").val();
                    let max = $(this).find("input[name='max_points[]']").val();
                    let goals = $(this).find("input[name='goals[]']").val();
                    if (min && max && goals) {
                        goalRules.push({
                            min: min,
                            max: max,
                            goals: goals
                        });
                    }
                });

                let goalRules2 = [];
                $("tr").each(function() {
                    let min = $(this).find("input[name='min_points2[]']").val();
                    let max = $(this).find("input[name='max_points2[]']").val();
                    let goals = $(this).find("input[name='goals2[]']").val();
                    if (min && max && goals) {
                        goalRules2.push({
                            min: min,
                            max: max,
                            goals: goals
                        });
                    }
                });

                // Other settings
                let settings = {
                    diff_band_margin: $("#diff_band_margin").val(),
                    same_band_margin: $("#same_band_margin").val(),
                    extra_goal_enabled: $("#extra_goal_enabled").is(":checked") ? 1 : 0,
                    extra_goal_margin: $("#extra_goal_margin").val(),
                    low_scoring_enabled: $("#low_scoring_enabled").is(":checked") ? 1 : 0,
                    low_score_threshold: $("#low_score_threshold").val(),
                    low_score_rules: $("#low_score_rules").val()
                };

                $.ajax({
                    url: "connect.php",
                    method: "POST",
                    data: {
                        updateRules: "Yes",
                        goalRules: JSON.stringify(goalRules),
                        settings: JSON.stringify(settings),
                        goalRules2: JSON.stringify(goalRules2)
                    },
                    success: function(res) {

                        if (res == 0) {
                            alert('Settings Updated');
                        } else {
                            alert('Error');
                        }
                    },
                    error: function(xhr) {
                        alert("Error saving settings");
                        console.log(xhr.responseText);
                    }
                });
            });
        </script>



        <?php include('footer.php') ?>

        </body>

</html>