<?php
session_start();
ob_start();
ob_clean();
ob_flush();

include('connect.php');
if (!isset($_SESSION['user_id'])) {
  header('location:login.php');
}
$admin_id = $_SESSION['user_id'];
?>


<meta name="description" content="Create and manage Fantasy Premier League team competitions. Track fixtures, results, and standings for groups of FPL managers with the FPL Maestros league system." />
<meta name="keywords" content="Fantasy Premier League, FPL league manager, FPL team competition, FPL fixtures, FPL standings, FPL results, FPL group league, FPL Maestros">


<!-- Favicon -->
<link rel="icon" type="image/x-icon" href="uploads/favicon.png" />

<!-- Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&amp;ampdisplay=swap" rel="stylesheet">

<!-- Icons -->
<link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />
<link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />

<!-- Menu waves for no-customizer fix -->
<link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

<!-- Core CSS -->
<link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
<link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
<link rel="stylesheet" href="assets/css/demo.css" />

<!-- Vendors CSS -->
<link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
<link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
<link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

<link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css">
<link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css">
<link rel="stylesheet" href="assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css">
<link rel="stylesheet" href="assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css">
<link rel="stylesheet" href="assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css">

<!-- Page CSS -->


<!-- Helpers -->
<script src="assets/vendor/js/helpers.js"></script>
<!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->

<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
<script src="assets/js/config.js"></script>
<script src="jquery.js"></script>


</head>

<body>

  <?php if (isset($report)) {
    echo Alert($report, $count);
  } ?>

  <!-- Layout wrapper -->
  <div class="layout-wrapper layout-content-navbar  ">
    <div class="layout-container">







      <!-- Menu -->

      <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">


        <div class="app-brand demo ">
          <a href="index" class="app-brand-link">
            <img src="uploads/maestros-modified.png" alt="Logo" height="40" width="40">
            <span class=" demo menu-text fw-semibold ms-2">FPL MAESTROS</span>
          </a>

          <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
            <i class="menu-toggle-icon d-xl-block align-middle"></i>
          </a>
        </div>

        <div class="menu-inner-shadow"></div>



        <ul class="menu-inner py-1">
          <!-- Dashboards -->

          <li class="menu-item linkk active">
            <a href="index" class="menu-link">
              <i class="menu-icon tf-icons ri-dashboard-line"></i>
              <div data-i18n="Dashboard">Dashboard</div>
            </a>
          </li>

          <li class="menu-item linkk">
            <a href="managers" class="menu-link">
              <i class="menu-icon tf-icons ri-user-3-line"></i>
              <div data-i18n="Managers">Managers</div>
            </a>
          </li>

          <li class="menu-item linkk">
            <a href="teams" class="menu-link">
              <i class="menu-icon tf-icons ri-team-line"></i>
              <div data-i18n="Teams">Teams</div>
            </a>
          </li>

          <li class="menu-item linkk2">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
              <i class="menu-icon tf-icons ri-calendar-event-line"></i>
              <div data-i18n="Fixtures">Fixtures</div>
            </a>
            <ul class="menu-sub">
              <li class="menu-item linkk">
                <a href="fixtures-1" class="menu-link">
                  <div data-i18n="Division 1">Division 1</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="fixtures-2" class="menu-link">
                  <div data-i18n="Division 2">Division 2</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="fixtures-3" class="menu-link">
                  <div data-i18n="Division 3">Division 3</div>
                </a>
              </li>
            </ul>
          </li>

          <!-- <li class="menu-item linkk">
      <a href="fixtures" class="menu-link">
        <i class="menu-icon tf-icons ri-calendar-event-line"></i>
        <div data-i18n="Fixtures">Fixtures</div>
      </a>
    </li> -->

          <!-- <li class="menu-item linkk">
            <a href="results" class="menu-link">
              <i class="menu-icon tf-icons ri-trophy-line"></i>
              <div data-i18n="Results">Results</div>
            </a>
          </li> -->
          <li class="menu-item open linkk2">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
              <i class="menu-icon tf-icons ri-trophy-line"></i>
              <div data-i18n="Results">Results</div>
            </a>
            <ul class="menu-sub">
              <li class="menu-item linkk">
                <a href="results-1" class="menu-link">
                  <div data-i18n="Division 1">Division 1</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="results-2" class="menu-link">
                  <div data-i18n="Division 2">Division 2</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="results-3" class="menu-link">
                  <div data-i18n="Division 3">Division 3</div>
                </a>
              </li>
            </ul>
          </li>

          <!-- <li class="menu-item linkk">
            <a href="table" class="menu-link">
              <i class="menu-icon tf-icons ri-list-ordered"></i>
              <div data-i18n="League Table">League Table</div>
            </a>
          </li> -->

          <li class="menu-item linkk2">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
              <i class="menu-icon tf-icons ri-list-ordered"></i>
              <div data-i18n="League Table">League Table</div>
            </a>
            <ul class="menu-sub">
              <li class="menu-item linkk">
                <a href="table-1" class="menu-link">
                  <div data-i18n="Division 1">Division 1</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="table-2" class="menu-link">
                  <div data-i18n="Division 2">Division 2</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="table-3" class="menu-link">
                  <div data-i18n="Division 3">Division 3</div>
                </a>
              </li>
            </ul>
          </li>

          <li class="menu-item linkk2">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
              <i class="menu-icon tf-icons ri-trophy-line"></i>
              <div data-i18n="Champions Cup">Champions Cup</div>
            </a>
            <ul class="menu-sub">
              <li class="menu-item linkk">
                <a href="cup-overview" class="menu-link">
                  <div data-i18n="Overview">Overview</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="cup-groups" class="menu-link">
                  <div data-i18n="Groups">Groups</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="cup-fixtures" class="menu-link">
                  <div data-i18n="Fixtures">Fixtures</div>
                </a>
              </li>
              <li class="menu-item linkk">
                <a href="cup-knockout" class="menu-link">
                  <div data-i18n="Knockout">Knockout</div>
                </a>
              </li>
            </ul>
          </li>

          <li class="menu-item linkk">
            <a href="settings" class="menu-link">
              <i class="menu-icon tf-icons ri-settings-3-line"></i>
              <div data-i18n="Settings">Settings</div>
            </a>
          </li>

           <li class="menu-item linkk">
            <a href="user-management" class="menu-link">
              <i class="menu-icon tf-icons ri-shield-user-line"></i>
              <div data-i18n="User Management">User Management</div>
            </a>
          </li>

          <li class="menu-item linkk">
            <a href="logout" class="menu-link">
              <i class="menu-icon tf-icons ri-logout-box-r-line"></i>
              <div data-i18n="Logout">Logout</div>
            </a>
          </li>


        </ul>
      </aside>
      <!-- / Menu -->



      <!-- Layout container -->
      <div class="layout-page">





        <!-- Navbar -->

        <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">









          <div class="layout-menu-toggle navbar-nav align-items-xl-center me-4 me-xl-0   d-xl-none ">
            <a class="nav-item nav-link px-0 me-xl-6" href="javascript:void(0)">
              <i class="ri-menu-fill ri-24px"></i>
            </a>
          </div>


          <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">




            <ul class="navbar-nav flex-row align-items-center ms-auto">



              <!-- User -->
              <li class="nav-item navbar-dropdown dropdown-user dropdown">
                <a class="nav-link dropdown-toggle hide-arrow p-0" href="javascript:void(0);" data-bs-toggle="dropdown">
                  <div class="avatar avatar-online">
                    <img src="assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle">
                  </div>
                </a>
                <ul class="dropdown-menu dropdown-menu-end mt-3 py-2">
                  <li>
                    <a class="dropdown-item" href="javascript:void(0)">
                      <div class="d-flex align-items-center">
                        <div class="flex-shrink-0 me-2">
                          <div class="avatar avatar-online">
                            <img src="assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle">
                          </div>
                        </div>
                        <div class="flex-grow-1">
                          <?php $spl = $db->query("SELECT * FROM users WHERE id = '$admin_id' ");
                          $roo = mysqli_fetch_assoc($spl); ?>
                          <h6 class="mb-0 small">Name: <?= $roo['name'] ?></h6>
                          <h6 class="mb-0 small">Username: <?= $roo['username'] ?></h6>
                          <h6 class="mb-0 small">Email: <?= $roo['email'] ?></h6>
                          <small class="text-muted">Admin</small>

                        </div>
                      </div>
                    </a>
                  </li>

                  <li>
                    <div class="d-grid px-4 pt-2 pb-1">
                      <a class="btn btn-danger d-flex" href="logout" target="_blank">
                        <small class="align-middle">Logout</small>
                        <i class="ri-logout-box-r-line ms-2 ri-16px"></i>
                      </a>
                    </div>
                  </li>
                </ul>
              </li>
              <!--/ User -->



            </ul>
          </div>


        </nav>
        <script>
          $(document).ready(function() {
            var pathname = window.location.pathname;
            pages = ['index', 'managers', 'teams', 'fixtures-1', 'fixtures-2', 'fixtures-3', 'results-1', 'results-2', 'results-3', 'table-1', 'table-2', 'table-3', 'cup-overview', 'cup-groups', 'cup-fixtures', 'cup-knockout', 'settings', 'user-management', 'logout'];

             pages2 = ['fixtures-', 'results-', 'table-', 'cup'];

            $('.linkk').each(function(i) {
              if (pathname.includes(pages[i])) {
                this.classList.add('active');
              } else if (this.className.includes('active')) {
                this.classList.remove('active');
              }
            });

            $('.linkk2').each(function(i) {
              if (pathname.includes(pages2[i])) {
                this.classList.add('open');
              } else if (this.className.includes('open')) {
                this.classList.remove('open');
              }
            });
          });
        </script>

        <!-- / Navbar -->