<?php

// Helper: Use cURL to fetch external data more reliably
function curl_fetch_url($url)
{
  // 1. Initialize cURL
  $ch = curl_init();

  // 2. Set options
  curl_setopt($ch, CURLOPT_URL, $url);
  // Return the transfer as a string instead of outputting it directly
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  // Follow any redirects
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
  // Set a timeout (optional, but good practice)
  curl_setopt($ch, CURLOPT_TIMEOUT, 10);
  // Set User-Agent (FPL API sometimes requires this)
  curl_setopt($ch, CURLOPT_USERAGENT, 'FPL-Maestros-App');

  // 3. Execute the request
  $json = curl_exec($ch);

  // 4. Check for errors (e.g., connection issue)
  if (curl_errno($ch)) {
    // You can log the error here if needed:
    // error_log('cURL Error: ' . curl_error($ch));
    curl_close($ch);
    return false;
  }

  // 5. Close cURL handle
  curl_close($ch);

  return $json;
}

function getFplTeamName($fpl_id)
{
  $url = "https://fantasy.premierleague.com/api/entry/{$fpl_id}/";
  $json = curl_fetch_url($url);
  if ($json === false) {
    return "Unknown";
  }
  $data = json_decode($json, true);
  if (!isset($data['player_first_name']) || !isset($data['player_last_name'])) {
    return "Unknown";
  }
  // Team name field is `name` in that response
  return $data['name'] ?? "{$data['player_first_name']} {$data['player_last_name']}";
}

function getFplTeamNameFromDb($fpl_id)
{
  global $db;
  $sql = $db->query("SELECT * FROM managers WHERE fpl_id = '$fpl_id'");
  $data = mysqli_fetch_assoc($sql);
  return $data['name'];
}


function getLatestGameweek()
{
  $url = "https://fantasy.premierleague.com/api/bootstrap-static/";
  $json = curl_fetch_url($url);

  if ($json === false) {
    return null;
  }

  $data = json_decode($json, true);
  $latestGw = null;

  if (isset($data['events']) && is_array($data['events'])) {
    foreach ($data['events'] as $event) {
      if ($event['is_current']) {
        // Current active gameweek
        $latestGw = $event['id'];
        break;
      }
      if ($event['finished']) {
        // Keep track of the last finished GW
        $latestGw = $event['id'];
      }
    }
  }

  return $latestGw;
}

function getTeamManagers($team_id)
{
  global $db;
  $managers = [];

  $sql = $db->query("SELECT manager1, manager2, manager3, manager4, manager5 FROM teams WHERE id = '$team_id'");
  $row = mysqli_fetch_assoc($sql);
  array_push($managers, $row['manager1'], $row['manager2'], $row['manager3'], $row['manager4'], $row['manager5']);


  return json_encode($managers);
}

function getManagersTeam($id)
{
  global $db;

  $sql = $db->query("SELECT * FROM teams WHERE manager1 = '$id' OR manager2 = '$id' OR manager3 = '$id' OR manager4 = '$id' OR manager5 = '$id'");
  $row = mysqli_fetch_assoc($sql);



  return $row['team_name'];
}


function getTeamDivision($id)
{
  global $db;

  $sql = $db->query("SELECT * FROM teams WHERE id = '$id' ");
  $row = mysqli_fetch_assoc($sql);



  return $row['division'];
}


