<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Champions Cup Overview | FPL Maestros</title>
    <?php include('nav.php') ?>
    <style>
        .stats-card {
            transition: transform 0.2s ease-in-out;
        }

        .stats-card:hover {
            transform: translateY(-5px);
        }

        .team-logo-sm {
            width: 25px;
            height: 25px;
            object-fit: contain;
            margin-right: 8px;
        }

        .top-scorer {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .progress {
            height: 8px;
        }

        .group-table {
            font-size: 0.9em;
        }

        .group-table th {
            background-color: #f8f9fa;
        }

        .qualified {
            background-color: #d4edda !important;
        }

        .eliminated {
            background-color: #f8d7da !important;
        }
    </style>
</head>

<body>

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">

            <?php
            function displayCupOverview($season = '2025')
            {
                global $db;

                echo "<div class='cup-overview'>";

                // Header Section
                echo "<div class='row mb-4'>";
                echo "<div class='col-12'>";
                echo "<div class='card top-scorer'>";
                echo "<div class='card-body text-center'>";
                echo "<h2 class='text-white mb-2'>🏆 Champions Cup $season</h2>";
                // echo "<p class='text-white mb-0'>The premier continental club competition</p>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";

                // Quick Stats Row
                displayQuickStats($season);

                // Group Stage Standings
                displayGroupStandings($season);

                // Top Performers
                displayTopPerformers($season);

                // Recent Matches
                displayRecentMatches($season);

                // Tournament Progress
                displayTournamentProgress($season);

                echo "</div>"; // cup-overview
            }

            function displayQuickStats($season)
            {
                global $db;

                // Total teams
                $total_teams = $db->query("SELECT COUNT(DISTINCT team_id) as total FROM cup_group_teams cgt 
                                     JOIN cup_groups cg ON cgt.group_id = cg.id 
                                     WHERE cg.season_year = '$season'")->fetch_assoc()['total'];

                // Matches played
                $matches_played = $db->query("SELECT COUNT(*) as total FROM cup_fixtures WHERE season_year = '$season' AND status = 'Closed'")->fetch_assoc()['total'];

                // Total goals
                $total_goals = $db->query("SELECT SUM(home_goals + away_goals) as total FROM cup_fixtures WHERE season_year = '$season' AND status = 'Closed'")->fetch_assoc()['total'] ?? 0;

                // Current stage
                $current_stage = $db->query("SELECT stage FROM cup_fixtures WHERE season_year = '$season' ORDER BY 
                                        CASE stage 
                                            WHEN 'F' THEN 5
                                            WHEN 'SF' THEN 4
                                            WHEN 'QF' THEN 3
                                            WHEN 'R16' THEN 2
                                            WHEN 'Group' THEN 1
                                            ELSE 0
                                        END DESC, gameweek DESC LIMIT 1")->fetch_assoc();
                $stage = $current_stage['stage'] ?? 'Group Stage';

                echo "<div class='row mb-4'>";

                echo "<div class='col-xl-3 col-md-6 mb-4'>";
                echo "<div class='card stats-card border-left-primary'>";
                echo "<div class='card-body'>";
                echo "<div class='row align-items-center'>";
                echo "<div class='col mr-2'>";
                echo "<div class='text-xs font-weight-bold text-primary text-uppercase mb-1'>Total Teams</div>";
                echo "<div class='h5 mb-0 font-weight-bold text-gray-800'>$total_teams</div>";
                echo "</div>";
                echo "<div class='col-auto'>";
                echo "<i class='fas fa-users fa-2x text-gray-300'></i>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";

                echo "<div class='col-xl-3 col-md-6 mb-4'>";
                echo "<div class='card stats-card border-left-success'>";
                echo "<div class='card-body'>";
                echo "<div class='row align-items-center'>";
                echo "<div class='col mr-2'>";
                echo "<div class='text-xs font-weight-bold text-success text-uppercase mb-1'>Matches Played</div>";
                echo "<div class='h5 mb-0 font-weight-bold text-gray-800'>$matches_played</div>";
                echo "</div>";
                echo "<div class='col-auto'>";
                echo "<i class='fas fa-futbol fa-2x text-gray-300'></i>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";

                echo "<div class='col-xl-3 col-md-6 mb-4'>";
                echo "<div class='card stats-card border-left-info'>";
                echo "<div class='card-body'>";
                echo "<div class='row align-items-center'>";
                echo "<div class='col mr-2'>";
                echo "<div class='text-xs font-weight-bold text-info text-uppercase mb-1'>Total Goals</div>";
                echo "<div class='h5 mb-0 font-weight-bold text-gray-800'>$total_goals</div>";
                echo "</div>";
                echo "<div class='col-auto'>";
                echo "<i class='fas fa-bullseye fa-2x text-gray-300'></i>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";

                echo "<div class='col-xl-3 col-md-6 mb-4'>";
                echo "<div class='card stats-card border-left-warning'>";
                echo "<div class='card-body'>";
                echo "<div class='row align-items-center'>";
                echo "<div class='col mr-2'>";
                echo "<div class='text-xs font-weight-bold text-warning text-uppercase mb-1'>Current Stage</div>";
                echo "<div class='h5 mb-0 font-weight-bold text-gray-800'>" . getStageDisplayName($stage) . "</div>";
                echo "</div>";
                echo "<div class='col-auto'>";
                echo "<i class='fas fa-trophy fa-2x text-gray-300'></i>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";
                echo "</div>";

                echo "</div>"; // row
            }

            function displayGroupStandings($season)
            {
                global $db;

                echo "<div class='card mb-4'>";
                echo "<div class='card-header d-flex justify-content-between align-items-center'>";
                echo "<h5 class='card-title mb-0'>Group Stage Standings</h5>";
                echo "<span class='badge bg-primary'>Top 2 Qualify for Knockouts</span>";
                echo "</div>";
                echo "<div class='card-body'>";

                $groups = $db->query("SELECT DISTINCT group_name FROM cup_groups WHERE season_year = '$season' ORDER BY group_name");

                echo "<div class='row'>";
                while ($group = $groups->fetch_assoc()) {
                    $group_name = $group['group_name'];

                    echo "<div class='col-lg-6 mb-4'>";
                    echo "<div class='card h-100'>";
                    echo "<div class='card-header bg-light'>";
                    echo "<h6 class='card-title mb-0'>Group $group_name</h6>";
                    echo "</div>";
                    echo "<div class='card-body p-0'>";

                    // Get group standings
                    $standings = $db->query("
                    SELECT 
                        t.team_name,
                        t.logo,
                        cgt.team_id,
                        (SELECT COUNT(*) FROM cup_fixtures WHERE (home_team_id = t.id OR away_team_id = t.id) 
                         AND stage = 'Group' AND status = 'Closed') as played,
                        (SELECT COUNT(*) FROM cup_fixtures WHERE home_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND home_goals > away_goals) +
                        (SELECT COUNT(*) FROM cup_fixtures WHERE away_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND away_goals > home_goals) as wins,
                        (SELECT COUNT(*) FROM cup_fixtures WHERE home_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND home_goals = away_goals) +
                        (SELECT COUNT(*) FROM cup_fixtures WHERE away_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND away_goals = home_goals) as draws,
                        (SELECT COUNT(*) FROM cup_fixtures WHERE home_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND home_goals < away_goals) +
                        (SELECT COUNT(*) FROM cup_fixtures WHERE away_team_id = t.id 
                         AND stage = 'Group' AND status = 'Closed' AND away_goals < home_goals) as losses,
                        (SELECT COALESCE(SUM(home_goals), 0) FROM cup_fixtures WHERE home_team_id = t.id AND stage = 'Group' AND status = 'Closed') +
                        (SELECT COALESCE(SUM(away_goals), 0) FROM cup_fixtures WHERE away_team_id = t.id AND stage = 'Group' AND status = 'Closed') as goals_for,
                        (SELECT COALESCE(SUM(away_goals), 0) FROM cup_fixtures WHERE home_team_id = t.id AND stage = 'Group' AND status = 'Closed') +
                        (SELECT COALESCE(SUM(home_goals), 0) FROM cup_fixtures WHERE away_team_id = t.id AND stage = 'Group' AND status = 'Closed') as goals_against
                    FROM cup_group_teams cgt
                    JOIN teams t ON cgt.team_id = t.id
                    JOIN cup_groups cg ON cgt.group_id = cg.id
                    WHERE cg.group_name = '$group_name' AND cg.season_year = '$season'
                    ORDER BY (wins * 3 + draws) DESC, (goals_for - goals_against) DESC, goals_for DESC
                ");

                    echo "<div class='table-responsive'>";
                    echo "<table class='table table-sm table-hover group-table mb-0'>";
                    echo "<thead class='table-light'>";
                    echo "<tr>";
                    echo "<th>Team</th>";
                    echo "<th>P</th>";
                    echo "<th>W</th>";
                    echo "<th>D</th>";
                    echo "<th>L</th>";
                    echo "<th>GF</th>";
                    echo "<th>GA</th>";
                    echo "<th>GD</th>";
                    echo "<th>Pts</th>";
                    echo "</tr>";
                    echo "</thead>";
                    echo "<tbody>";

                    $position = 0;
                    while ($team = $standings->fetch_assoc()) {
                        $position++;
                        $points = ($team['wins'] * 3) + $team['draws'];
                        $goal_difference = $team['goals_for'] - $team['goals_against'];
                        $row_class = $position <= 2 ? 'qualified' : ($position >= 3 ? 'eliminated' : '');

                        echo "<tr class='$row_class'>";
                        echo "<td>";
                        echo "<div class='d-flex align-items-center'>";
                        echo "<img src='uploads/{$team['logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo-sm'>";
                        echo "<span class='fw-medium'>{$team['team_name']}</span>";
                        echo "</div>";
                        echo "</td>";
                        echo "<td>{$team['played']}</td>";
                        echo "<td>{$team['wins']}</td>";
                        echo "<td>{$team['draws']}</td>";
                        echo "<td>{$team['losses']}</td>";
                        echo "<td>{$team['goals_for']}</td>";
                        echo "<td>{$team['goals_against']}</td>";
                        echo "<td>" . ($goal_difference > 0 ? "+" : "") . "$goal_difference</td>";
                        echo "<td><strong>$points</strong></td>";
                        echo "</tr>";
                    }

                    echo "</tbody>";
                    echo "</table>";
                    echo "</div>";

                    echo "</div>";
                    echo "</div>";
                    echo "</div>";
                }
                echo "</div>"; // row
                echo "</div>";
                echo "</div>";
            }

            function displayTopPerformers($season)
            {
                global $db;

                echo "<div class='row mb-4'>";

                // Top Scorers
                echo "<div class='col-lg-12 mb-4'>";
                echo "<div class='card h-100'>";
                echo "<div class='card-header'>";
                echo "<h6 class='card-title mb-0'>🎯 Top Scorers</h6>";
                echo "</div>";
                echo "<div class='card-body'>";

                $top_scorers = $db->query("
                SELECT 
                    p.name,
                    t.team_name,
                    t.logo,
                    COUNT(g.id) as goals
                FROM cup_goalscorers g
                JOIN managers p ON g.manager_id = p.fpl_id
                JOIN teams t ON g.team_id = t.id
                JOIN cup_fixtures cf ON g.fixture_id = cf.id
                WHERE cf.season_year = '$season' AND cf.stage LIKE 'Group%'
                GROUP BY p.id, p.name, t.team_name, t.logo
                ORDER BY goals DESC
                LIMIT 5
            ");

                if ($top_scorers->num_rows > 0) {
                    $rank = 1;
                    while ($scorer = $top_scorers->fetch_assoc()) {
                        echo "<div class='d-flex align-items-center mb-3'>";
                        echo "<span class='badge bg-primary me-3'>$rank</span>";
                        echo "<img src='uploads/{$scorer['logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo-sm'>";
                        echo "<div class='flex-grow-1'>";
                        echo "<div class='fw-medium'>{$scorer['name']}</div>";
                        echo "<small class='text-muted'>{$scorer['team_name']}</small>";
                        echo "</div>";
                        echo "<span class='badge bg-success'>{$scorer['goals']} goals</span>";
                        echo "</div>";
                        $rank++;
                    }
                } else {
                    echo "<p class='text-muted text-center'>No goal data available</p>";
                }

                echo "</div>";
                echo "</div>";
                echo "</div>";



                echo "</div>"; // row
            }

            function displayRecentMatches($season)
            {
                global $db;

                echo "<div class='card mb-4'>";
                echo "<div class='card-header'>";
                echo "<h5 class='card-title mb-0'>Recent Matches</h5>";
                echo "</div>";
                echo "<div class='card-body'>";

                $recent_matches = $db->query("
        SELECT 
            f.*,
            t1.team_name as home_team,
            t1.logo as home_logo,
            t2.team_name as away_team, 
            t2.logo as away_logo
        FROM cup_fixtures f
        JOIN teams t1 ON f.home_team_id = t1.id
        JOIN teams t2 ON f.away_team_id = t2.id
        WHERE f.season_year = '$season' AND f.status = 'Closed'
        ORDER BY f.updated_at DESC, f.id DESC
        LIMIT 8
    ");

                if ($recent_matches->num_rows > 0) {
                    echo "<div class='row'>";
                    while ($match = $recent_matches->fetch_assoc()) {
                        echo "<div class='col-md-6 mb-3'>";
                        echo "<div class='border rounded p-3'>";
                        echo "<div class='d-flex align-items-center justify-content-between mb-2'>";

                        // Home team
                        echo "<div class='d-flex align-items-center' style='width: 45%;'>";
                        echo "<img src='uploads/{$match['home_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo-sm'>";
                        echo "<span class='fw-medium text-truncate'>{$match['home_team']}</span>";
                        echo "</div>";

                        // Score
                        echo "<div class='text-center mx-2'>";
                        echo "<span class='fw-bold fs-6'>{$match['home_goals']} - {$match['away_goals']}</span>";
                        echo "</div>";

                        // Away team
                        echo "<div class='d-flex align-items-center justify-content-end' style='width: 45%;'>";
                        echo "<span class='fw-medium text-truncate me-2'>{$match['away_team']}</span>";
                        echo "<img src='uploads/{$match['away_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo-sm'>";
                        echo "</div>";

                        echo "</div>";

                        // Match info
                        echo "<div class='d-flex justify-content-between align-items-center'>";
                        echo "<small class='text-muted'>" . getStageDisplayName($match['stage']) . "</small>";

                        // Show additional info based on stage
                        if ($match['stage'] == 'Group') {
                            // For group stage, you might want to get group info differently
                            echo "<small class='text-muted'>Group Stage</small>";
                        } else if ($match['stage'] != 'F') {
                            // For knockout stages (except final), show leg info
                            echo "<small class='text-muted'>Leg {$match['leg']}</small>";
                        }

                        echo "</div>";

                        echo "</div>";
                        echo "</div>";
                    }
                    echo "</div>";
                } else {
                    echo "<p class='text-muted text-center'>No recent matches found</p>";
                }

                echo "</div>";
                echo "</div>";
            }

            function displayTournamentProgress($season)
            {
                global $db;

                echo "<div class='card'>";
                echo "<div class='card-header'>";
                echo "<h5 class='card-title mb-0'>Tournament Progress</h5>";
                echo "</div>";
                echo "<div class='card-body'>";

                $stages = ['Group', 'R16', 'QF', 'SF', 'F'];
                $total_matches = 0;
                $completed_matches = 0;

                foreach ($stages as $stage) {
                    $stage_total = $db->query("SELECT COUNT(*) as total FROM cup_fixtures WHERE season_year = '$season' AND stage = '$stage'")->fetch_assoc()['total'];
                    $stage_completed = $db->query("SELECT COUNT(*) as completed FROM cup_fixtures WHERE season_year = '$season' AND stage = '$stage' AND status = 'Closed'")->fetch_assoc()['completed'];

                    $total_matches += $stage_total;
                    $completed_matches += $stage_completed;

                    $percentage = $stage_total > 0 ? ($stage_completed / $stage_total) * 100 : 0;

                    echo "<div class='mb-3'>";
                    echo "<div class='d-flex justify-content-between mb-1'>";
                    echo "<span class='fw-medium'>" . getStageDisplayName($stage) . "</span>";
                    echo "<span>$stage_completed/$stage_total</span>";
                    echo "</div>";
                    echo "<div class='progress'>";
                    echo "<div class='progress-bar' role='progressbar' style='width: $percentage%' aria-valuenow='$percentage' aria-valuemin='0' aria-valuemax='100'></div>";
                    echo "</div>";
                    echo "</div>";
                }

                $overall_percentage = $total_matches > 0 ? ($completed_matches / $total_matches) * 100 : 0;

                echo "<div class='mt-4 p-3 bg-light rounded'>";
                echo "<div class='d-flex justify-content-between align-items-center'>";
                echo "<span class='fw-bold'>Overall Progress</span>";
                echo "<span class='fw-bold'>$completed_matches/$total_matches matches (" . round($overall_percentage, 1) . "%)</span>";
                echo "</div>";
                echo "<div class='progress mt-2' style='height: 12px;'>";
                echo "<div class='progress-bar bg-success' role='progressbar' style='width: $overall_percentage%' aria-valuenow='$overall_percentage' aria-valuemin='0' aria-valuemax='100'></div>";
                echo "</div>";
                echo "</div>";

                echo "</div>";
                echo "</div>";
            }

            function getStageDisplayName($stage)
            {
                $names = [
                    'Group' => 'Group Stage',
                    'R16' => 'Round of 16',
                    'QF' => 'Quarter Finals',
                    'SF' => 'Semi Finals',
                    'F' => 'Final'
                ];
                return $names[$stage] ?? $stage;
            }

            // Display the cup overview
            displayCupOverview('2025');
            ?>

        </div>
        <!-- / Content -->
    </div>

    <?php include('footer.php') ?>

</body>

</html>