<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Champions Cup Knockout Bracket | FPL Maestros</title>
    <?php include('nav.php') ?>
    <style>
        /* Add these rules to prevent horizontal scroll */
        body {
            overflow-x: hidden;
            max-width: 100vw;
        }

        .content-wrapper {
            overflow-x: hidden;
        }

        .container-xxl {
            max-width: 100%;
            overflow-x: hidden;
        }

        /* Media query for smaller screens */
        @media (max-width: 1400px) {
            .bracket {
                padding: 10px;
            }

            .column {
                margin: 0 5px;
            }

            .match {
                min-width: 180px;
                max-width: 180px;
                margin: 10px 10px 10px 0;
            }
        }

        @media (max-width: 1200px) {
            .card-body {
                overflow-x: auto;
                /* Allow horizontal scroll on smaller screens */
            }

            .bracket {
                width: max-content;
            }
        }



        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            padding: 20px;
        }

        h1 {
            text-align: center;
            color: #333;
        }

        .theme {
            height: 100%;
            width: 100%;
            position: absolute;
        }

        .bracket {
            padding: 40px;
            margin: 5px;
        }

        .bracket {
            display: flex;
            flex-direction: row;
            position: relative;
        }

        .column {
            display: flex;
            flex-direction: column;
            min-height: 100%;
            justify-content: space-around;
            align-content: center;
        }

        .match {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 240px;
            max-width: 240px;
            height: 62px;
            margin: 12px 24px 12px 0;
        }

        .match .match-top {
            border-radius: 2px 2px 0 0;
        }

        .match .match-bottom {
            border-radius: 0 0 2px 2px;
        }

        .match .team {
            display: flex;
            align-items: center;
            width: 100%;
            height: 100%;
            border: 1px solid black;
            position: relative;
        }

        .match .team span {
            padding-left: 8px;
        }

        .match .team span:last-child {
            padding-right: 8px;
        }

        .match .team .score {
            margin-left: auto;
        }

        .match .team:first-child {
            margin-bottom: -1px;
        }

        .match-lines {
            display: block;
            position: absolute;
            top: 50%;
            bottom: 0;
            margin-top: 0px;
            right: -1px;
        }

        .match-lines .line {
            background: red;
            position: absolute;
        }

        .match-lines .line.one {
            height: 1px;
            width: 12px;
        }

        .match-lines .line.two {
            height: 44px;
            width: 1px;
            left: 11px;
        }

        .match-lines.alt {
            left: -12px;
        }

        .match:nth-child(even) .match-lines .line.two {
            transform: translate(0, -100%);
        }

        .column:first-child .match-lines.alt {
            display: none;
        }

        .column:last-child .match-lines {
            display: none;
        }

        .column:last-child .match-lines.alt {
            display: block;
        }

        .column:nth-child(2) .match-lines .line.two {
            height: 88px;
        }

        .column:nth-child(3) .match-lines .line.two {
            height: 175px;
        }

        .column:nth-child(4) .match-lines .line.two {
            height: 262px;
        }

        .column:nth-child(5) .match-lines .line.two {
            height: 349px;
        }



        .disable-borders {
            border-width: 0px !important;
        }

        .disable-borders .team {
            border-width: 0px !important;
        }

        .disable-seperator .match-top {
            border-bottom: 0px !important;
        }

        .disable-seperator .match-bottom {
            border-top: 0px !important;
        }

        .disable-seperator .team:first-child {
            margin-bottom: 0px;
        }


        /* Team Box */
        .team {
            padding: 12px 15px;
            background-color: #fefefe;
            cursor: pointer;
            transition: background-color 0.2s;
            display: flex;
            align-items: center;
            min-height: 40px;
        }

        .team:hover {
            background-color: #f0f0f0;
        }

        /* Separator line between two teams in a matchup */
        .team+.team {
            border-top: 1px solid #ccc;
        }

        /* Team Seed Number */
        .team-seed {
            font-weight: bold;
            color: #888;
            margin-right: 10px;
        }

        /* Style for the winner */
        .team.winner {
            background-color: #e0ffe0;
            font-weight: bold;
        }

        .team.winner span {
            color: #2a8a2a;
        }

        .team-logo {
            width: 20px;
            height: 20px;
            margin-right: 8px;
            object-fit: contain;
        }

        .team-name {
            flex: 1;
        }

        .score {
            font-weight: bold;
            margin-left: 10px;
            color: #333;
        }

        .aggregate {
            font-size: 0.8em;
            color: #666;
            margin-left: 5px;
        }
    </style>


    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class='container-xxl flex-grow-1 container-p-y' style='padding-left: 10px; padding-right: 10px;'>
            <div class="theme theme-dark">

            </div>

            <?php
            function displayKnockoutBracket($season = '2025')
            {
                global $db;

                echo "<div class='card'>";
                echo "<div class='card-header'>";
                echo "<h4>🏆 Champions Cup - Knockout Bracket</h4>";
                echo "</div>";

                // Get all knockout fixtures
                $knockout_fixtures = $db->query("
                SELECT 
                    f.*,
                    t1.team_name as home_team,
                    t1.logo as home_logo,
                    t2.team_name as away_team, 
                    t2.logo as away_logo
                FROM cup_fixtures f
                JOIN teams t1 ON f.home_team_id = t1.id
                JOIN teams t2 ON f.away_team_id = t2.id
                WHERE f.stage IN ('R16', 'QF', 'SF', 'F')
                AND f.season_year = '$season'
                ORDER BY 
                    CASE f.stage 
                        WHEN 'R16' THEN 1
                        WHEN 'QF' THEN 2
                        WHEN 'SF' THEN 3
                        WHEN 'F' THEN 4
                        ELSE 5
                    END,
                    f.tie_identifier,
                    f.leg
            ");

                // Organize fixtures by stage and tie
                $bracket_data = [
                    'R16' => [],
                    'QF' => [],
                    'SF' => [],
                    'F' => []
                ];

                while ($fixture = $knockout_fixtures->fetch_assoc()) {
                    $stage = $fixture['stage'];
                    $tie_identifier = $fixture['tie_identifier'] ?? $stage;

                    if (!isset($bracket_data[$stage][$tie_identifier])) {
                        $bracket_data[$stage][$tie_identifier] = [];
                    }
                    $bracket_data[$stage][$tie_identifier][] = $fixture;
                }
                echo "<div class='card-body'>";
                echo "<div class='bracket disable-image'>";

                // Round of 16 (8 matchups)
                displayBracketRound($bracket_data['R16'], 'r-1', 'Round of 16');

                // Quarter Finals (4 matchups)
                displayBracketRound($bracket_data['QF'], 'r-2', 'Quarter Finals');

                // Semi Finals (2 matchups)
                displayBracketRound($bracket_data['SF'], 'r-3', 'Semi Finals');

                // Final (1 matchup)
                displayFinalRound($bracket_data['F'], 'r-4', 'Final');

                echo "</div>"; // bracket
                echo "</div>";

                echo "</div>"; // knockout-bracket
            }

            function displayBracketRound($round_fixtures, $round_class, $round_title)
            {
                echo "<div class='column one'>";

                if (empty($round_fixtures)) {
                    // Display placeholder matchups if no data
                    $matchup_count = getExpectedMatchupCount($round_class);
                    for ($i = 0; $i < $matchup_count; $i++) {
                        echo "<div class='matchup'>";
                        echo "<div class='team tbd'><span>?</span>TBD</div>";
                        echo "<div class='team tbd'><span>?</span>TBD</div>";
                        echo "</div>";
                    }
                } else {
                    $matchup_index = 1;
                    foreach ($round_fixtures as $tie_identifier => $fixtures) {
                        $match_data = processKnockoutTie($fixtures, $round_class);
                        displayBracketMatchup($match_data, $round_class, $matchup_index);
                        $matchup_index++;
                    }
                }

                echo "</div>"; // round
            }

            function displayFinalRound($final_fixtures, $round_class, $round_title)
            {
                echo "<div class='column four'>";

                if (empty($final_fixtures)) {
                    echo "<div class='matchup'>";
                    echo "<div class='team tbd champion'><span>🏆</span>Champion TBD</div>";
                    echo "</div>";
                } else {
                    $final = reset($final_fixtures);
                    // Check if $final is an array with at least one element
                    if (isset($final[0]) && is_array($final[0])) {
                        $match = $final[0];

                        $home_team = $match['home_team'] ?? 'TBD';
                        $away_team = $match['away_team'] ?? 'TBD';
                        $home_logo = $match['home_logo'] ?? 'assets/img/avatars/1.png';
                        $away_logo = $match['away_logo'] ?? 'assets/img/avatars/1.png';
                        $home_goals = $match['home_goals'] ?? null;
                        $away_goals = $match['away_goals'] ?? null;
                        $status = $match['status'] ?? 'Pending';
                        $winner_id = $match['winner_team_id'] ?? null;

                        $home_winner = $winner_id && isset($match['home_team_id']) && $winner_id == $match['home_team_id'];
                        $away_winner = $winner_id && isset($match['away_team_id']) && $winner_id == $match['away_team_id'];
                    } else {
                        // Default values if no final match exists
                        $home_team = 'TBD';
                        $away_team = 'TBD';
                        $home_logo = 'assets/img/avatars/1.png';
                        $away_logo = 'assets/img/avatars/1.png';
                        $home_goals = null;
                        $away_goals = null;
                        $status = 'Pending';
                        $winner_id = null;
                        $home_winner = false;
                        $away_winner = false;
                    }
            ?>
                    <div class="match winner-top matchup">
                        <?php
                        if ($status == 'Closed' && $winner_id) {
                            $winner_name = $home_winner ? $home_team : $away_team;
                            $winner_logo = $home_winner ? $home_logo : $away_logo;
                            echo "<div class='team winner champion'>";
                            echo "<img src='uploads/$winner_logo' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                            echo "<span class='team-name'>$winner_name</span>";
                            echo "<span class='score'>$home_goals - $away_goals</span>";
                            echo "</div>";
                        } else {
                            // Show both teams if final not completed
                        ?>
                            <div class="match-top team <?= ($home_winner ? 'winner' : '') ?>">
                                <span class="image"><img src='uploads/<?= $home_logo ?>' onerror="this.src='assets/img/avatars/1.png'" class='team-logo'></span>
                                <!-- <span class="team-seed">1</span> -->
                                <span class="team-name"><?= $home_team ?></span>
                                <?php
                                if ($status == 'Closed') {
                                    echo "<span class='score'>$home_goals</span>";
                                }
                                ?>
                            </div>
                            <div class="match-bottom team <?= ($away_winner ? 'winner' : '') ?>">
                                <span class="image"><img src='uploads/<?= $away_logo ?>' onerror="this.src='assets/img/avatars/1.png'" class='team-logo'></span>
                                <!-- <span class="team-seed">8</span> -->
                                <span class="team-name"><?= $away_team ?></span>

                                <?php
                                if ($status == 'Closed') {
                                    echo "<span class='score'>$away_goals</span>";
                                }
                                ?>
                            </div>
                            <div class="match-lines">
                                <div class="line one"></div>
                                <div class="line two"></div>
                            </div>
                            <div class="match-lines alt">
                                <div class="line one"></div>
                            </div>
                        <?php } ?>
                    </div>
                <?php

                    // echo "<div class='matchup'>";

                    // if ($status == 'Closed' && $winner_id) {
                    //     $winner_name = $home_winner ? $home_team : $away_team;
                    //     $winner_logo = $home_winner ? $home_logo : $away_logo;
                    //     echo "<div class='team winner champion'>";
                    //     echo "<img src='uploads/$winner_logo' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                    //     echo "<span class='team-name'>$winner_name</span>";
                    //     echo "<span class='score'>$home_goals - $away_goals</span>";
                    //     echo "</div>";
                    // } else {
                    //     // Show both teams if final not completed
                    //     echo "<div class='team " . ($home_winner ? 'winner' : '') . "'>";
                    //     echo "<img src='uploads/$home_logo' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                    //     echo "<span class='team-name'>$home_team</span>";
                    //     if ($status == 'Closed') {
                    //         echo "<span class='score'>$home_goals</span>";
                    //     }
                    //     echo "</div>";

                    //     echo "<div class='team " . ($away_winner ? 'winner' : '') . "'>";
                    //     echo "<img src='uploads/$away_logo' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                    //     echo "<span class='team-name'>$away_team</span>";
                    //     if ($status == 'Closed') {
                    //         echo "<span class='score'>$away_goals</span>";
                    //     }
                    //     echo "</div>";
                    // }

                    // echo "</div>"; // matchup
                }

                echo "</div>"; // round
            }

            function displayBracketMatchup($match_data, $round_class, $matchup_index)
            {
                $home_winner = $match_data['winner_id'] == $match_data['home_team_id'];
                $away_winner = $match_data['winner_id'] == $match_data['away_team_id'];
                $is_completed = $match_data['status'] == 'Completed'; ?>

                <div class="match winner-top matchup">
                    <div class="match-top team <?= ($home_winner ? 'winner' : '') ?>">
                        <span class="image"><img src='uploads/<?= $match_data['home_logo'] ?>' onerror="this.src='assets/img/avatars/1.png'" class='team-logo'></span>
                        <!-- <span class="seed">1</span> -->
                        <span class="team-name"><?= $match_data['home_team'] ?></span>
                        <?php
                        if ($is_completed) {
                            echo "<span class='score'>{$match_data['aggregate_home']}</span>";
                            if ($round_class == 'r-1') {
                                echo "<span class='aggregate'>(agg)</span>";
                            }
                        }
                        ?>
                    </div>
                    <div class="match-bottom team <?= ($away_winner ? 'winner' : '') ?>">
                        <span class="image"><img src='uploads/<?= $match_data['away_logo'] ?>' onerror="this.src='assets/img/avatars/1.png'" class='team-logo'></span>
                        <!-- <span class="seed">8</span> -->
                        <span class="team-name"><?= $match_data['away_team'] ?></span>

                        <?php
                        if ($is_completed) {
                            echo "<span class='score'>{$match_data['aggregate_away']}</span>";
                            if ($round_class == 'r-1') {
                                echo "<span class='aggregate'>(agg)</span>";
                            }
                        }
                        ?>
                    </div>
                    <div class="match-lines">
                        <div class="line one"></div>
                        <div class="line two"></div>
                    </div>
                    <div class="match-lines alt">
                        <div class="line one"></div>
                    </div>
                </div>
            <?php

                // echo "<div class='matchup'>";

                // // Home team
                // echo "<div class='team " . ($home_winner ? 'winner' : '') . "'>";
                // echo "<img src='uploads/{$match_data['home_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                // echo "<span class='team-name'>{$match_data['home_team']}</span>";
                // if ($is_completed) {
                //     echo "<span class='score'>{$match_data['aggregate_home']}</span>";
                //     if ($round_class == 'r-1') {
                //         echo "<span class='aggregate'>(agg)</span>";
                //     }
                // }
                // echo "</div>";

                // // Away team
                // echo "<div class='team " . ($away_winner ? 'winner' : '') . "'>";
                // echo "<img src='uploads/{$match_data['away_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='team-logo'>";
                // echo "<span class='team-name'>{$match_data['away_team']}</span>";
                // if ($is_completed) {
                //     echo "<span class='score'>{$match_data['aggregate_away']}</span>";
                //     if ($round_class == 'r-1') {
                //         echo "<span class='aggregate'>(agg)</span>";
                //     }
                // }
                // echo "</div>";

                // echo "</div>"; // matchup
            }

            function processKnockoutTie($fixtures, $round)
            {
                $home_team = null;
                $away_team = null;
                $home_logo = null;
                $away_logo = null;
                $home_goals = 0;
                $away_goals = 0;
                $status = 'Pending';
                $winner_id = null;
                $aggregate_home = 0;
                $aggregate_away = 0;

                foreach ($fixtures as $fixture) {
                    if (!$home_team) {
                        $home_team = $fixture['home_team'];
                        $home_logo = $fixture['home_logo'];
                    }
                    if (!$away_team) {
                        $away_team = $fixture['away_team'];
                        $away_logo = $fixture['away_logo'];
                    }

                    if ($fixture['leg'] == 1) {
                        $aggregate_home += $fixture['home_goals'];
                        $aggregate_away += $fixture['away_goals'];
                    } else {
                        $aggregate_home += $fixture['away_goals']; // Away goals count to home aggregate
                        $aggregate_away += $fixture['home_goals']; // Home goals count to away aggregate
                    }

                    if ($fixture['status'] == 'Closed') {
                        $status = 'Completed';
                        if ($fixture['winner_team_id']) {
                            $winner_id = $fixture['winner_team_id'];
                        }
                    }
                }

                // Determine winner if not set but aggregate exists
                if (!$winner_id && $status == 'Completed') {
                    if ($aggregate_home > $aggregate_away) {
                        $winner_id = $fixtures[0]['home_team_id'];
                    } elseif ($aggregate_away > $aggregate_home) {
                        $winner_id = $fixtures[0]['away_team_id'];
                    }
                }

                return [
                    'home_team' => $home_team,
                    'away_team' => $away_team,
                    'home_logo' => $home_logo,
                    'away_logo' => $away_logo,
                    'aggregate_home' => $aggregate_home,
                    'aggregate_away' => $aggregate_away,
                    'status' => $status,
                    'winner_id' => $winner_id,
                    'home_team_id' => $fixtures[0]['home_team_id'],
                    'away_team_id' => $fixtures[0]['away_team_id']
                ];
            }

            function getExpectedMatchupCount($round_class)
            {
                switch ($round_class) {
                    case 'r-1':
                        return 8; // Round of 16
                    case 'r-2':
                        return 4; // Quarter Finals
                    case 'r-3':
                        return 2; // Semi Finals
                    case 'r-4':
                        return 1; // Final
                    default:
                        return 0;
                }
            }

            // Display the knockout bracket
            displayKnockoutBracket('2025');
            ?>

        </div>
        <!-- / Content -->
    </div>

    <?php include('footer.php') ?>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    </body>

</html>