<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/"  data-style="light">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Champions Cup Fixtures | FPL Maestros</title>
    <?php include('nav.php') ?>
</head>
<body>

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">

        <?php
        function displayAllFixturesByGameweek($season = '2025') {
            global $db;
            
            echo "<div class='cup-fixtures'>";
            echo "<h4>🏆 Champions Cup - All Fixtures</h4>";

            // Get all gameweeks
            $cup_gameweeks = [12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 38];

            foreach ($cup_gameweeks as $gameweek) {
                // SIMPLE QUERY - No complex joins that cause duplicates
                $fixtures = $db->query("
                    SELECT 
                        f.*,
                        t1.team_name as home_team,
                        t1.logo as home_logo,
                        t2.team_name as away_team, 
                        t2.logo as away_logo
                    FROM cup_fixtures f
                    JOIN teams t1 ON f.home_team_id = t1.id
                    JOIN teams t2 ON f.away_team_id = t2.id
                    WHERE f.gameweek = $gameweek 
                    AND f.season_year = '$season'
                    ORDER BY f.stage, f.id
                ");

                $fixture_count = $fixtures->num_rows;
                if ($fixture_count == 0) continue;

                echo "<div class='card mb-4'>";
                echo "<div class='card-header'>";
                echo "<h5 class='card-title mb-0'>Gameweek $gameweek - " . getStageName($gameweek) . "</h5>";
                echo "<span class='badge bg-primary'>$fixture_count matches</span>";
                echo "</div>";
                
                echo "<div class='card-body'>";
                
                // Group by stage manually
                $fixtures_by_stage = [];
                while ($fixture = $fixtures->fetch_assoc()) {
                    $stage = $fixture['stage'];
                    if (!isset($fixtures_by_stage[$stage])) {
                        $fixtures_by_stage[$stage] = [];
                    }
                    $fixtures_by_stage[$stage][] = $fixture;
                }
                
                foreach ($fixtures_by_stage as $stage => $stage_fixtures) {
                    echo "<div class='stage-section mb-4'>";
                    echo "<h6 class='text-muted mb-3'>" . getStageDisplayName($stage) . "</h6>";
                    
                    // For group stage, get group information separately
                    if ($stage == 'Group') {
                        displayGroupStageFixtures($stage_fixtures, $season);
                    } else {
                        // For knockout stages
                        foreach ($stage_fixtures as $fixture) {
                            displayFixtureSimple($fixture, $stage);
                        }
                    }
                    
                    echo "</div>"; // stage-section
                }
                
                echo "</div>"; // card-body
                echo "</div>"; // card
            }
            
            echo "</div>"; // cup-fixtures
        }

        function displayGroupStageFixtures($fixtures, $season) {
            global $db;
            
            // Get group information for each team
            $team_groups = [];
            $groups_result = $db->query("
                SELECT cgt.team_id, cg.group_name 
                FROM cup_group_teams cgt
                JOIN cup_groups cg ON cgt.group_id = cg.id
                WHERE cg.season_year = '$season'
            ");
            
            while ($group_row = $groups_result->fetch_assoc()) {
                $team_groups[$group_row['team_id']] = $group_row['group_name'];
            }
            
            // Group fixtures by their actual group
            $fixtures_by_group = [];
            foreach ($fixtures as $fixture) {
                $home_team_id = $fixture['home_team_id'];
                $group = $team_groups[$home_team_id] ?? 'Unknown';
                if (!isset($fixtures_by_group[$group])) {
                    $fixtures_by_group[$group] = [];
                }
                $fixtures_by_group[$group][] = $fixture;
            }
            
            // Sort groups alphabetically
            ksort($fixtures_by_group);
            
            // Display each group
            foreach ($fixtures_by_group as $group_name => $group_fixtures) {
                echo "<div class='group-section mb-3'>";
                echo "<h6 class='text-primary mb-2'>Group $group_name</h6>";
                
                foreach ($group_fixtures as $fixture) {
                    displayFixtureSimple($fixture, 'Group');
                }
                
                echo "</div>"; // group-section
            }
        }

        function displayFixtureSimple($fixture, $stage) {
            $status = $fixture['status'];
            $home_goals = $fixture['home_goals'];
            $away_goals = $fixture['away_goals'];
            
            echo "<div class='fixture mb-2 p-2 border rounded'>";
            echo "<div class='d-flex align-items-center justify-content-between'>";
            
            // Home team
            echo "<div class='d-flex align-items-center' style='width: 40%;'>";
            echo "<img src='uploads/{$fixture['home_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" class='me-2' style='width: 20px; height: 20px; object-fit: contain;'>";
            echo "<span class='text-truncate'>{$fixture['home_team']}</span>";
            echo "</div>";
            
            // Score/VS
            echo "<div class='mx-2 text-center' style='min-width: 60px;'>";
            if ($status == 'Closed') {
                $home_class = $home_goals > $away_goals ? 'text-success fw-bold' : '';
                $away_class = $away_goals > $home_goals ? 'text-success fw-bold' : '';
                
                echo "<span class='$home_class'>{$home_goals}</span>";
                echo " : ";
                echo "<span class='$away_class'>{$away_goals}</span>";
            } else {
                echo "<span class='text-muted'>vs</span>";
            }
            echo "</div>";
            
            // Away team
            echo "<div class='d-flex align-items-center justify-content-end' style='width: 40%;'>";
            echo "<span class='text-truncate me-2'>{$fixture['away_team']}</span>";
            echo "<img src='uploads/{$fixture['away_logo']}' onerror=\"this.src='assets/img/avatars/1.png'\" style='width: 20px; height: 20px; object-fit: contain;'>";
            echo "</div>";
            
            echo "</div>";
            
            // Status and info
            echo "<div class='d-flex justify-content-between align-items-center mt-1'>";
            if ($status == 'Closed') {
                echo "<span class='badge bg-success badge-sm'>FT</span>";
            } else {
                echo "<span class='badge bg-secondary badge-sm'>Scheduled</span>";
            }
            
            echo "<small class='text-muted'>";
            if ($stage != 'Group' && $stage != 'F') {
                echo "Leg {$fixture['leg']}";
                if ($fixture['tie_identifier']) {
                    echo " • {$fixture['tie_identifier']}";
                }
            }
            echo "</small>";
            echo "</div>";
            
            echo "</div>";
        }

        function getStageName($gameweek) {
            $stages = [
                12 => 'Group MD1',
                14 => 'Group MD2',
                16 => 'Group MD3',
                18 => 'Group MD4',
                20 => 'Group MD5',
                22 => 'Group MD6',
                24 => 'R16 Leg 1',
                26 => 'R16 Leg 2',
                28 => 'QF Leg 1',
                30 => 'QF Leg 2',
                32 => 'SF Leg 1',
                34 => 'SF Leg 2',
                38 => 'Final'
            ];
            return $stages[$gameweek] ?? 'Knockout';
        }

        function getStageDisplayName($stage) {
            $names = [
                'Group' => 'Group Stage',
                'R16' => 'Round of 16',
                'QF' => 'Quarter Finals',
                'SF' => 'Semi Finals',
                'F' => 'Final'
            ];
            return $names[$stage] ?? $stage;
        }

        // Simple debug to verify counts
        function verifyFixtureCounts($season) {
            global $db;
            
            $counts = $db->query("
                SELECT gameweek, stage, COUNT(*) as count 
                FROM cup_fixtures 
                WHERE season_year = '$season' 
                GROUP BY gameweek, stage 
                ORDER BY gameweek, stage
            ");
            
            echo "<div class='alert alert-info mb-4'>";
            echo "<h6>Database Fixture Counts</h6>";
            echo "<div class='row'>";
            
            while ($row = $counts->fetch_assoc()) {
                echo "<div class='col-md-3 mb-2'>";
                echo "<strong>GW{$row['gameweek']} {$row['stage']}:</strong> {$row['count']}";
                echo "</div>";
            }
            
            echo "</div>";
            echo "</div>";
        }

        // Display the page
        // verifyFixtureCounts('2025');
        displayAllFixturesByGameweek('2025');
        ?>

    </div>
    <!-- / Content -->
</div>

<?php include('footer.php') ?>

</body>
</html>