<?php
class Maestros
{
    public function __construct()
    {
        if (array_key_exists('login', $_POST)) {
            $this->login();
        } elseif (array_key_exists('add_manager', $_POST)) {
            $this->add_manager();
        } elseif (array_key_exists('edit_manager', $_POST)) {
            $this->edit_manager();
        } elseif (array_key_exists('delete_manager', $_POST)) {
            $this->delete_manager();
        } elseif (array_key_exists('add_team', $_POST)) {
            $this->add_team();
        } elseif (array_key_exists('update_team', $_POST)) {
            $this->update_team();
        } elseif (array_key_exists('delete_team', $_POST)) {
            $this->delete_team();
        } elseif (array_key_exists('generate_fixtures', $_POST)) {
            extract($_POST);
            $this->generate_fixtures($division);
        } elseif (array_key_exists('get_gameweeks', $_GET)) {
            extract($_GET);
            $this->get_gameweeks($division);
        } elseif (array_key_exists('get_fixtures', $_GET)) {
            extract($_GET);
            $this->get_fixtures($division);
        } elseif (array_key_exists('get_fixt_details', $_GET)) {
            extract($_GET);
            $this->get_fixt_details($division);
        } elseif (array_key_exists('getFPLname', $_GET)) {
            $fpl_id = intval($_GET['getFPLname']);
            $this->getFPLname($fpl_id);
        } elseif (array_key_exists('getFPLscore', $_GET)) {
            $fpl_id = intval($_GET['getFPLscore']);
            $gw = intval($_GET['gmwk']);
            $this->getFPLscore($fpl_id, $gw);
        } elseif (array_key_exists('get_gw_status', $_GET)) {
            $gw = intval($_GET['get_gw_status']);
            $this->get_gw_status($gw);
        } elseif (array_key_exists('get_gw_status2', $_GET)) {
            extract($_GET);
            $this->get_gw_status2($get_gw_status2);
        } elseif (array_key_exists('updateRules', $_POST)) {
            $this->updateRules();
        } elseif (array_key_exists('load_goal_rules', $_GET)) {
            $this->load_goal_rules();
        } elseif (array_key_exists('load_settings', $_GET)) {
            $this->load_settings();
        } elseif (array_key_exists('refreshLeagueTable', $_GET)) {
            extract($_GET);
            $this->refreshLeagueTable($division);
        } elseif (array_key_exists('updateAllResults', $_POST)) {
            $this->updateAllResults();
        } elseif (array_key_exists('updateManagerHistories', $_POST)) {
            $this->updateManagerHistories();
        } elseif (array_key_exists('getFixturesWithResults', $_GET)) {
            extract($_GET);
            $this->getFixturesWithResults($gw, $division);
        } elseif (array_key_exists('getGoalscorers', $_GET)) {
            extract($_GET);
            $this->getGoalscorers($gw, $division);
        }elseif (array_key_exists('getDivTeamRankings', $_GET)) {
            extract($_GET);
            $this->getDivTeamRankings($division);
        } elseif (array_key_exists('getNextDeadline', $_GET)) {
            $this->getNextDeadline();
        } elseif (array_key_exists('fetchLeagueTeams', $_GET)) {
            $this->fetchLeagueTeams();
        } elseif (array_key_exists('getOverallTeamRankings', $_GET)) {
            $this->getOverallTeamRankings();
        }
    }

    function login()
    {
        global $db, $report, $count;
        extract($_POST);
        if (empty($loginfo) || empty($password)) {
            $report = 'All fields are required';
            $count = 1;
            return;
        }
        $loginfo = $db->real_escape_string($loginfo);
        $ck = $db->query("SELECT * FROM users WHERE username ='$loginfo' OR email = '$loginfo'");
        if (mysqli_num_rows($ck) == 0) {
            $report = 'Incorrect Details';
            $count = 1;
            return;
        }
        $row = mysqli_fetch_assoc($ck);
        if (!password_verify($password, $row['password'])) {
            $report = 'Incorrect Details';
            $count = 1;
            return;
        } else {
            $_SESSION['user_id'] = $row['id'];
            header('location:index.php');
            $report = 'Login Successful';
            $count = 0;
            return;
        }
        return;
    }

    function add_manager()
    {
        global $db, $report, $count;
        extract($_POST);
        $name = $db->real_escape_string($name);
        $fpl_id = $db->real_escape_string($fpl_id);

        if (empty($name) || empty($fpl_id)) {
            $report = "All fields are required";
            $count = 1;
            return;
        }

        $sql = $db->query("SELECT * FROM managers WHERE fpl_id = '$fpl_id'");
        if (mysqli_num_rows($sql) >= 1) {
            $report = 'The FPL ID already exists';
            $count = 1;
            return;
        }

        $ck = $db->query("INSERT INTO managers(name, fpl_id)VALUES('$name', '$fpl_id')") or die(mysqli_error($db));
        $report = 'Manager added successfully';
        $count = 0;
    }

    function edit_manager()
    {
        global $db, $report, $count;
        extract($_POST);
        $id = $db->real_escape_string($id);
        $name = $db->real_escape_string($name);
        $fpl_id = $db->real_escape_string($fpl_id);

        $sql = $db->query("UPDATE managers SET name = '$name', fpl_id = '$fpl_id' WHERE id = '$id'");
        $report = "Manager info updated successfully";
        $count = 0;
    }

    function delete_manager()
    {
        global $db, $report, $count;
        extract($_POST);

        $sql = $db->query("DELETE FROM managers WHERE id = '$id'");
        if ($sql) {
            $report = "Manager deleted successfully";
            $count = 0;
            return;
        }
    }

    function add_team()
    {
        global $db, $report, $count;
        extract($_POST);

        $team_name = $db->real_escape_string($team_name);
        $division = $db->real_escape_string($division);


        $imageName = basename($_FILES['logo']['name']);
        $extension = explode('.', $imageName);
        $extension = end($extension);
        $new_imgName = "p" . $this->win_hashs(6) . time() . "." . $extension;
        $path = "uploads/";
        $allowed_image_extensions = array("png", "jpg", "jpeg", "gif");
        $targetFilePath1 = $path . $new_imgName;

        // Check for duplicates
        if (count($fpl_ids) != 5 || count($fpl_ids) != count(array_unique($fpl_ids))) {
            $report = "You must enter 5 unique FPL IDs";
            $count = 1;
            return;
        }

        $sqlx = $db->query("SELECT id FROM teams WHERE team_name = '$team_name'");
        if (mysqli_num_rows($sqlx) > 0) {
            $report = "Team name already exists";
            $count = 1;
            return;
        }

        // Check each manager
        foreach ($fpl_ids as $id) {
            $sql = $db->query("SELECT id FROM teams WHERE manager1 = '$id' OR manager2 = '$id' OR manager3 = '$id' OR manager4 = '$id' OR manager5 = '$id'");
            $row = mysqli_fetch_assoc($sql);

            if (mysqli_num_rows($sql) > 0) {
                $report = "Manager with FPL ID $id already belongs to another team";
                $count = 1;
                return;
            }
            $man_name = getFplTeamName($id);
            $man_name = $db->real_escape_string($man_name);
            $sql2 = $db->query("SELECT * FROM managers WHERE fpl_id = '$id' ");
            if (mysqli_num_rows($sql2) > 0) {
                $sqlxx = $db->query("UPDATE managers SET name = '$man_name' WHERE fpl_id = '$id' ");
            } else {
                $sqlxx = $db->query("INSERT INTO managers(name, fpl_id) VALUES('$man_name', '$id')");
            }
        }

        if (!empty($imageName)) {
            if ((in_array($extension, $allowed_image_extensions))) {
                if (move_uploaded_file($_FILES["logo"]["tmp_name"], $targetFilePath1)) {
                    $stmt = $db->query("INSERT INTO teams(team_name, division, logo, manager1, manager2, manager3, manager4, manager5)VALUES('$team_name', '$division', '$new_imgName', '$fpl_ids[0]', '$fpl_ids[1]', '$fpl_ids[2]', '$fpl_ids[3]', '$fpl_ids[4]')") or die(mysqli_error($db));
                    $report = "Team created successfully";
                    $count = 0;
                    return;
                } else {
                    $report = "Sorry, there was an error uploading logo";
                    $count = 1;
                    return;
                }
            } else {
                $report = 'Sorry, only JPG, JPEG, PNG, GIF files are allowed.';
                $count = 1;
                return;
            }
        } else {
            $stmt = $db->query("INSERT INTO teams(team_name, division, manager1, manager2, manager3, manager4, manager5)VALUES('$team_name', '$division', '$fpl_ids[0]', '$fpl_ids[1]', '$fpl_ids[2]', '$fpl_ids[3]', '$fpl_ids[4]')") or die(mysqli_error($db));
            $report = "Team created successfully";
            $count = 0;
            return;
        }
    }

    public function win_hashs($length)
    {
        return substr(str_shuffle(str_repeat('123456789abcdefghijklmnopqrstuvwxyz', $length)), 0, $length);
    }

    function update_team()
    {
        global $db, $report, $count;
        extract($_POST);

        $team_name = $db->real_escape_string($team_name);



        $imageName = basename($_FILES['logo']['name']);
        $extension = explode('.', $imageName);
        $extension = end($extension);
        $new_imgName = "p" . $this->win_hashs(6) . time() . "." . $extension;
        $path = "uploads/";
        $allowed_image_extensions = array("png", "jpg", "jpeg", "gif");
        $targetFilePath1 = $path . $new_imgName;

        // Check for duplicates
        if (count($fpl_ids) != 5 || count($fpl_ids) != count(array_unique($fpl_ids))) {
            $report = "You must enter 5 unique FPL IDs";
            $count = 1;
            return;
        }

        $sqlx = $db->query("SELECT id FROM teams WHERE team_name = '$team_name' and id != '$id'");
        if (mysqli_num_rows($sqlx) > 0) {
            $report = "Team name already exists";
            $count = 1;
            return;
        }

        // Check each manager
        foreach ($fpl_ids as $ids) {
            $sql = $db->query("SELECT id FROM teams WHERE (manager1 = '$ids' OR manager2 = '$ids' OR manager3 = '$ids' OR manager4 = '$ids' OR manager5 = '$ids') AND (id != '$id')");

            if (mysqli_num_rows($sql) > 0) {
                $report = "Manager with FPL ID $ids already belongs to another team";
                $count = 1;
                return;
            }
            $man_name = getFplTeamName($ids);
            $man_name = $db->real_escape_string($man_name);
            $sql2 = $db->query("SELECT * FROM managers WHERE fpl_id = '$ids' ");
            if (mysqli_num_rows($sql2) > 0) {
                $sqlxx = $db->query("UPDATE managers SET name = '$man_name' WHERE fpl_id = '$ids' ");
            } else {
                $sqlxx = $db->query("INSERT INTO managers(name, fpl_id) VALUES('$man_name', '$ids')");
            }
        }

        if (!empty($imageName)) {
            if ((in_array($extension, $allowed_image_extensions))) {
                if (move_uploaded_file($_FILES["logo"]["tmp_name"], $targetFilePath1)) {
                    $stmt = $db->query("UPDATE teams SET team_name = '$team_name', logo = '$new_imgName', manager1 = '$fpl_ids[0]', manager2 = '$fpl_ids[1]', manager3 = '$fpl_ids[2]', manager4 = '$fpl_ids[3]', manager5 = '$fpl_ids[4]' WHERE id = '$id'") or die(mysqli_error($db));
                    $report = "Team updated successfully";
                    $count = 0;
                    return;
                } else {
                    $report = "Sorry, there was an error uploading logo";
                    $count = 1;
                    return;
                }
            } else {
                $report = 'Sorry, only JPG, JPEG, PNG, GIF files are allowed.';
                $count = 1;
                return;
            }
        } else {
            $stmt = $db->query("UPDATE teams SET team_name = '$team_name', manager1 = '$fpl_ids[0]', manager2 = '$fpl_ids[1]', manager3 = '$fpl_ids[2]', manager4 = '$fpl_ids[3]', manager5 = '$fpl_ids[4]' WHERE id = '$id'") or die(mysqli_error($db));
            $report = "Team updated successfully";
            $count = 0;
            return;
        }
    }

    function delete_team()
    {
        global $db, $report, $count;
        extract($_POST);

        $sql = $db->query("DELETE FROM teams WHERE id = '$id'");
        if ($sql) {
            $report = "Team deleted successfully";
            $count = 0;
            return;
        }
    }

    function generate_fixtures($division)
    {
        global $db, $report, $count;

        // Clear old fixtures
        // $db->query("TRUNCATE TABLE fixtures");
        $db->query("DELETE FROM fixtures WHERE division = '$division' ");

        // Load teams
        $teams = [];
        $sql = $db->query("SELECT id FROM teams WHERE division = '$division' ORDER BY id");
        while ($row = mysqli_fetch_assoc($sql)) {
            $teams[] = $row['id'];
        }
        $numTeams = count($teams);

        // Add a bye week if odd number of teams
        $hasBye = false;
        if ($numTeams % 2 !== 0) {
            $teams[] = null;
            $numTeams++;
            $hasBye = true;
        }

        $half = $numTeams - 1; // number of rounds per half
        $matchesPerRound = $numTeams / 2;
        $rounds = [];

        // Berger algorithm (round robin)
        for ($round = 0; $round < $half; $round++) {
            $roundMatches = [];
            for ($i = 0; $i < $matchesPerRound; $i++) {
                $home = $teams[$i];
                $away = $teams[$numTeams - 1 - $i];
                if ($home !== null && $away !== null) {
                    // Randomize home/away assignment in the first half
                    if (rand(0, 1) === 1) {
                        $roundMatches[] = ['home' => $home, 'away' => $away];
                    } else {
                        $roundMatches[] = ['home' => $away, 'away' => $home];
                    }
                }
            }
            $rounds[$round] = $roundMatches;

            // Rotate teams (except first)
            $last = array_pop($teams);
            array_splice($teams, 1, 0, $last);
        }

        // Build fixtures
        $fixtures = [];

        // First half
        for ($round = 0; $round < $half; $round++) {
            foreach ($rounds[$round] as $match) {
                $fixtures[] = [
                    'home' => $match['home'],
                    'away' => $match['away'],
                    'gameweek' => $round + 1
                ];
            }
        }

        // Second half (reverse home/away)
        for ($round = 0; $round < $half; $round++) {
            foreach ($rounds[$round] as $match) {
                $fixtures[] = [
                    'home' => $match['away'],
                    'away' => $match['home'],
                    'gameweek' => $round + 1 + $half
                ];
            }
        }

        // Insert into DB
        foreach ($fixtures as $f) {
            $home = $f['home'];
            $away = $f['away'];
            $gw   = $f['gameweek'];
            $db->query("INSERT INTO fixtures(home_team_id, away_team_id, gameweek, division)VALUES('$home', '$away', '$gw', '$division')");
        }

        return true;
    }

    function get_gameweeks($division)
    {
        global $db, $report, $count;
        $result = $db->query("SELECT DISTINCT gameweek FROM fixtures WHERE division = '$division' ORDER BY id ASC");

        $gws = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $gws[] = $row['gameweek'];
        }

        echo json_encode($gws);
    }

    function get_fixtures($division)
    {
        global $db, $report, $count;

        $gw = intval($_GET['gw']);

        $sql = $db->query("SELECT f.id, f.home_team_id, f.away_team_id, th.team_name AS home_team, th.logo AS home_logo, ta.team_name AS away_team, ta.logo AS away_logo FROM fixtures f JOIN teams th ON f.home_team_id = th.id JOIN teams ta ON f.away_team_id = ta.id WHERE f.gameweek = $gw AND f.division = '$division' ORDER BY f.id ASC");
        $fixtures = [];
        while ($row = mysqli_fetch_assoc($sql)) {
            $fixtures[] = $row;
        }

        header('Content-Type: application/json');
        echo json_encode($fixtures);
    }

    function get_fixt_details($division)
    {
        global $db, $report, $count;

        $sql = $db->query("SELECT f.id AS fixture_id, f.gameweek, th.team_name AS home_team, ta.team_name AS away_team, th.logo AS home_logo, ta.logo AS away_logo, JSON_ARRAY(th.manager1, th.manager2, th.manager3, th.manager4, th.manager5) AS home_managers, JSON_ARRAY(ta.manager1, ta.manager2, ta.manager3, ta.manager4, ta.manager5) AS away_managers FROM fixtures f JOIN teams th ON f.home_team_id = th.id JOIN teams ta ON f.away_team_id = ta.id WHERE f.division = '$division' ORDER BY f.gameweek, f.id");

        $fixtures = [];
        while ($row = mysqli_fetch_assoc($sql)) {
            $gw = $row['gameweek'];

            // Decode JSON for managers
            $row['home_managers'] = json_decode($row['home_managers'], true);
            $row['away_managers'] = json_decode($row['away_managers'], true);

            if (!isset($fixtures[$gw])) {
                $fixtures[$gw] = [];
            }
            $fixtures[$gw][] = $row;
        }

        header('Content-Type: application/json');
        echo json_encode($fixtures);
    }

    function getFPLname($managerId)
    {
        global $db, $report, $count;

        $url = "https://fantasy.premierleague.com/api/entry/" . $managerId . "/";
        $response = curl_fetch_url($url);
        echo $response;
    }

    function getFPLscore($managerId, $gw)
    {
        global $db, $report, $count;

        $url = "https://fantasy.premierleague.com/api/entry/" . $managerId . "/history/";
        $json = curl_fetch_url($url);

        if ($json === false) {
            echo json_encode(["error" => "Unable to fetch data"]);
            return;
        }

        $data = json_decode($json, true);
        $score = null;
        $netScore = null;

        if (isset($data['current']) && is_array($data['current'])) {
            foreach ($data['current'] as $week) {
                if ($week['event'] == $gw) {
                    $score = $week['points'];
                    $event_transfers_cost = $week['event_transfers_cost'];
                    $netScore = $week['points'] - $week['event_transfers_cost'];
                    break;
                }
            }
        }

        echo json_encode([
            "managerId" => $managerId,
            "gw" => $gw,
            "points" => $score ?? 0,
            "event_transfers_cost" => $event_transfers_cost ?? 0,
            "net_points" => $netScore ?? 0
        ]);
    }

    function get_gw_status($gw)
    {
        $url = "https://fantasy.premierleague.com/api/bootstrap-static/";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo json_encode(["error" => "Failed to fetch data"]);
            exit;
        }
        curl_close($ch);

        $data = json_decode($response, true);

        $status = "Pending";
        foreach ($data['events'] as $event) {
            if ($event['id'] == $gw) {
                if ($event['finished']) {
                    $status = "Closed";
                } elseif ($event['is_current']) {
                    $status = "Live";
                } else {
                    $status = "Pending";
                }
                break;
            }
        }

        echo json_encode(["gw" => $gw, "status" => $status]);
    }

    function get_gw_status2($gw)
    {
        $url = "https://fantasy.premierleague.com/api/bootstrap-static/";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo json_encode(["error" => "Failed to fetch data"]);
            exit;
        }
        curl_close($ch);

        $data = json_decode($response, true);

        $status = "Pending";
        foreach ($data['events'] as $event) {
            if ($event['id'] == $gw) {
                if ($event['finished']) {
                    $status = "Closed";
                } elseif ($event['is_current']) {
                    $status = "Live";
                } else {
                    $status = "Pending";
                }
                break;
            }
        }

        echo $status;
    }

    function updateRules()
    {
        global $db, $report, $count;

        extract($_POST);

        $goalRules = json_decode($_POST['goalRules'], true);
        $goalRules2 = json_decode($_POST['goalRules2'], true);
        $settings  = json_decode($_POST['settings'], true);

        // Clear old goal rules
        $sql = $db->query("DELETE FROM goal_rules");
        $sql2 = $db->query("DELETE FROM low_goal_rules");
        $sqlx = $db->query("DELETE FROM settings");

        // Insert new goal rules
        foreach ($goalRules as $rule) {
            $ruleMin = $rule['min'];
            $ruleMax = $rule['max'];
            $ruleGoals = $rule['goals'];
            $stmt = $db->query("INSERT INTO goal_rules (min_points, max_points, goals) VALUES ('$ruleMin', '$ruleMax', '$ruleGoals')");
        }

        foreach ($goalRules2 as $rule2) {
            $ruleMin = $rule2['min'];
            $ruleMax = $rule2['max'];
            $ruleGoals = $rule2['goals'];
            $stmt2 = $db->query("INSERT INTO low_goal_rules (min_points, max_points, goals) VALUES ('$ruleMin', '$ruleMax', '$ruleGoals')");
        }

        // Insert/update settings
        $diff_band_margin = $settings['diff_band_margin'];
        $same_band_margin = $settings['same_band_margin'];
        $extra_goal_enabled = $settings['extra_goal_enabled'];
        $extra_goal_margin = $settings['extra_goal_margin'];
        $low_scoring_enabled = $settings['low_scoring_enabled'];
        $low_score_threshold = $settings['low_score_threshold'];
        $stm = $db->query("INSERT INTO settings (diff_band_margin, same_band_margin, extra_goal_enabled, extra_goal_margin, low_scoring_enabled, low_score_threshold)VALUES('$diff_band_margin', '$same_band_margin', '$extra_goal_enabled', '$extra_goal_margin', '$low_scoring_enabled', '$low_score_threshold')");

        if ($stmt && $stm && $stmt2) {
            echo 0;
        } else {
            echo 1;
        }
    }

    function load_goal_rules()
    {
        global $db, $report, $count;
        $query = $db->query("SELECT * FROM goal_rules ORDER BY min_points ASC");

        $rules = [];
        while ($row = mysqli_fetch_assoc($query)) {
            $rules[] = $row;
        }

        echo json_encode($rules);
    }

    function load_settings()
    {
        global $db, $report, $count;
        $query = $db->query("SELECT diff_band_margin, same_band_margin, extra_goal_enabled, extra_goal_margin FROM settings ORDER BY id ASC");

        $rules = [];
        while ($row = mysqli_fetch_assoc($query)) {
            $rules[] = $row;
        }

        echo json_encode($rules);
    }

    function saveResult($fixtureId, $gameweek, $homeTeamId, $awayTeamId, $homePoints, $awayPoints, $homeGoals, $awayGoals, $status, $explanation)
    {
        global $db;
        extract($_POST);
        // Check if result already exists
        $check = $db->query("SELECT id FROM results WHERE fixture_id = '$fixtureId' AND gameweek = '$gameweek'");
        $existing = mysqli_num_rows($check);

        if ($existing >= 1) {
            // Update existing
            $stmt = $db->query("UPDATE results SET home_points = '$homePoints', away_points = '$awayPoints', home_goals = '$homeGoals', away_goals = '$awayGoals', status = '$status', explanation = '$explanation', updated_at = NOW() WHERE fixture_id = '$fixtureId' AND gameweek = '$gameweek' ");
        } else {
            // Insert new
            $stmt = $db->query("INSERT INTO results 
            (fixture_id, gameweek, home_team, away_team, home_points, away_points, home_goals, away_goals, status, explanation) 
            VALUES ('$fixtureId', '$gameweek', '$homeTeamId', '$awayTeamId', '$homePoints', '$awayPoints', '$homeGoals', '$awayGoals', '$status', '$explanation')");
        }
    }

    // helper: fetch FPL history for one manager (returns associative array or null)
    function fetchFplHistory($managerId)
    {
        $url = "https://fantasy.premierleague.com/api/entry/{$managerId}/history/";
        $json = curl_fetch_url($url);
        if ($json === false) return null;
        $data = json_decode($json, true);
        return is_array($data) ? $data : null;
    }


    function sumManagersPoints($managers, $gw)
    {
        global $db;
        $total = 0;

        if (is_string($managers)) {
            $try = json_decode($managers, true);
            $managers = is_array($try) ? $try : [];
        }

        foreach ($managers as $m) {
            $m = intval($m);
            if ($m <= 0) continue;

            $sql = $db->query("SELECT net_points FROM manager_history WHERE manager_id = '$m' AND event = '$gw' LIMIT 1");
            $row = mysqli_fetch_assoc($sql);
            if ($row) {
                $total += intval($row['net_points']);
            }
        }

        return $total;
    }


    function applyGoalRules($homePoints, $awayPoints)
    {
        global $db;
        // load goal rules
        $goalRules = [];
        $qr = $db->query("SELECT id, min_points, max_points, goals FROM goal_rules ORDER BY min_points ASC");
        while ($r = mysqli_fetch_assoc($qr)) {
            $goalRules[] = [
                'id' => intval($r['id']),
                'min' => intval($r['min_points']),
                'max' => intval($r['max_points']),
                'goals' => intval($r['goals'])
            ];
        }

        if (empty($goalRules)) {
            return ['error' => 'No goal rules found'];
        }

        // helper: find band by points
        $findBand = function ($points) use ($goalRules) {
            foreach ($goalRules as $band) {
                if ($points >= $band['min'] && $points <= $band['max']) {
                    return $band;
                }
            }
            return null;
        };

        $homeBand = $findBand($homePoints);
        $awayBand = $findBand($awayPoints);

        if (!$homeBand || !$awayBand) {
            return ['error' => 'Points do not fall into any goal band', 'home_band' => $homeBand, 'away_band' => $awayBand];
        }

        // load settings in one query
        $settings = [
            'same_band_margin' => 5,
            'diff_band_margin' => 5,
            'extra_goal_enabled' => 0,
            'extra_goal_margin' => 10
        ];

        $query = $db->query("SELECT diff_band_margin, same_band_margin, extra_goal_enabled, extra_goal_margin FROM settings ORDER BY id ASC");

        $rules = [];
        $settings = [];
        while ($row = mysqli_fetch_assoc($query)) {
            $rules[] = $row;
        }

        $settings = $rules[0];

        $homeGoals = $homeBand['goals'];
        $awayGoals = $awayBand['goals'];
        $margin = abs($homePoints - $awayPoints);
        $explanation = '';

        // same band logic
        if ($homeBand['id'] === $awayBand['id']) {
            if ($margin > intval($settings['same_band_margin'])) {
                if ($homePoints > $awayPoints) {
                    $homeGoals += 1;
                    $explanation = "Same band, margin > {$settings['same_band_margin']} → +1 to Home";
                } else {
                    $awayGoals += 1;
                    $explanation = "Same band, margin > {$settings['same_band_margin']} → +1 to Away";
                }
            } else {
                $explanation = "Same band, margin ≤ {$settings['same_band_margin']} → Draw";
            }
        } else {
            // different bands
            if ($margin <= intval($settings['diff_band_margin'])) {
                $drawGoals = min($homeGoals, $awayGoals);
                $homeGoals = $drawGoals;
                $awayGoals = $drawGoals;
                $explanation = "Different bands, margin ≤ {$settings['diff_band_margin']} → Forced draw at lower band goals";
            } else {
                $explanation = "Different bands, margin > {$settings['diff_band_margin']} → Goals by band";
            }
        }

        // extra goal rule per your request:
        // if extra_goal_enabled == 0 then add one goal to higher points side when margin <= extra_goal_margin
        if (intval($settings['extra_goal_enabled']) === 0) {
            $egm = intval($settings['extra_goal_margin']);
            if ($margin <= $egm && $margin > 0) {
                if ($homePoints > $awayPoints) {
                    $homeGoals += 1;
                    $explanation .= " | Extra rule: +1 to Home (margin ≤ {$egm})";
                } elseif ($awayPoints > $homePoints) {
                    $awayGoals += 1;
                    $explanation .= " | Extra rule: +1 to Away (margin ≤ {$egm})";
                }
            }
        }

        return [
            'home_points' => $homePoints,
            'away_points' => $awayPoints,
            'home_goals' => intval($homeGoals),
            'away_goals' => intval($awayGoals),
            'home_band' => $homeBand,
            'away_band' => $awayBand,
            'margin' => $margin,
            'explanation' => $explanation
        ];
    }



    function getAllGwStatuses()
    {
        $url = "https://fantasy.premierleague.com/api/bootstrap-static/";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {
            return [];
        }

        $data = json_decode($response, true);
        $statuses = [];

        foreach ($data['events'] as $event) {
            if ($event['finished']) {
                $statuses[$event['id']] = "Closed";
            } elseif ($event['is_current']) {
                $statuses[$event['id']] = "Live";
            } else {
                $statuses[$event['id']] = "Pending";
            }
        }

        return $statuses; // array: [ gwId => "Closed"/"Live"/"Pending" ]
    }


    function updateAllResults()
    {
        global $db;

        $latestGW = getLatestGameweek();
        $gwStatuses = $this->getAllGwStatuses(); // fetch once

        // Step 1: collect all manager IDs in DB
        $managers = [];
        $teamRes = $db->query("SELECT manager1, manager2, manager3, manager4, manager5 FROM teams");
        while ($row = mysqli_fetch_assoc($teamRes)) {
            foreach ($row as $m) {
                if ($m && intval($m) > 0) {
                    $managers[intval($m)] = null;
                }
            }
        }

        // Step 2: fetch all histories ONCE
        foreach ($managers as $id => $_) {
            $managers[$id] = $this->fetchFplHistory($id);
        }

        // Step 3: process fixtures
        for ($gw = 1; $gw <= $latestGW; $gw++) {
            $fixt = $db->query("SELECT * FROM fixtures WHERE gameweek = '$gw'");

            while ($f = mysqli_fetch_assoc($fixt)) {
                $home_managers = getTeamManagers($f['home_team_id']);
                $away_managers = getTeamManagers($f['away_team_id']);

                $homePoints = $this->sumManagersPoints($home_managers, $gw, $managers);
                $awayPoints = $this->sumManagersPoints($away_managers, $gw, $managers);

                $goals = $this->applyGoalRules($homePoints, $awayPoints);

                // Use pre-fetched status
                $status = isset($gwStatuses[$gw]) ? $gwStatuses[$gw] : "Pending";

                $this->saveResult(
                    $f['id'],
                    $gw,
                    $f['home_team_id'],
                    $f['away_team_id'],
                    $homePoints,
                    $awayPoints,
                    $goals['home_goals'],
                    $goals['away_goals'],
                    $status,
                    $goals['explanation']
                );
            }
        }
    }

    function updateManagerHistories()
    {
        global $db;

        // Get all unique manager IDs from teams
        $managers = [];
        $res = $db->query("SELECT manager1, manager2, manager3, manager4, manager5 FROM teams");
        while ($row = mysqli_fetch_assoc($res)) {
            foreach ($row as $m) {
                if ($m && intval($m) > 0) {
                    $managers[intval($m)] = true;
                }
            }
        }

        foreach (array_keys($managers) as $managerId) {
            $history = $this->fetchFplHistory($managerId);

            if (!$history || !isset($history['current'])) continue;

            foreach ($history['current'] as $week) {
                $gw = intval($week['event']);
                $points = intval($week['points'] ?? 0);
                $transferCost = intval($week['event_transfers_cost'] ?? 0);
                $net = $points - $transferCost;

                // Insert or update row
                $sp = $db->query("SELECT * FROM manager_history WHERE manager_id = '$managerId' AND event = '$gw'");
                if (mysqli_num_rows($sp) >= 1) {
                    $db->query("UPDATE manager_history SET points = '$points', transfer_cost = '$transferCost', net_points = '$net' WHERE manager_id = '$managerId' AND event = '$gw'");
                } else {
                    $db->query("INSERT INTO manager_history (manager_id, event, points, transfer_cost, net_points)VALUES ('$managerId', '$gw', '$points', '$transferCost', '$net')");
                }
            }
        }
    }

    function getFixturesWithResults($gw, $division)
    {
        global $db;

        $stmt = $db->query("SELECT f.id AS fixture_id, f.gameweek, f.home_team_id, f.away_team_id, th.team_name AS home_team, ta.team_name AS away_team, th.logo AS home_logo, ta.logo AS away_logo, th.manager1 AS h1, th.manager2 AS h2, th.manager3 AS h3, th.manager4 AS h4, th.manager5 AS h5, ta.manager1 AS a1, ta.manager2 AS a2, ta.manager3 AS a3, ta.manager4 AS a4, ta.manager5 AS a5, r.home_points, r.away_points, r.home_goals, r.away_goals, r.status, r.explanation FROM fixtures f JOIN teams th ON f.home_team_id = th.id JOIN teams ta ON f.away_team_id = ta.id LEFT JOIN results r ON r.fixture_id = f.id AND r.gameweek = f.gameweek WHERE f.gameweek = '$gw' AND f.division = '$division' ORDER BY f.id ASC");

        $fixtures = [];
        while ($row = mysqli_fetch_assoc($stmt)) {

            // Collect manager IDs
            $homeIds = array_filter([$row['h1'], $row['h2'], $row['h3'], $row['h4'], $row['h5']]);
            $awayIds = array_filter([$row['a1'], $row['a2'], $row['a3'], $row['a4'], $row['a5']]);

            // Replace manager IDs with full objects
            $row['home_managers'] = [];
            foreach ($homeIds as $mid) {
                $row['home_managers'][] = $this->getManagerDetails($mid, $gw);
            }

            $row['away_managers'] = [];
            foreach ($awayIds as $mid) {
                $row['away_managers'][] = $this->getManagerDetails($mid, $gw);
            }

            // Drop raw manager fields
            unset($row['h1'], $row['h2'], $row['h3'], $row['h4'], $row['h5']);
            unset($row['a1'], $row['a2'], $row['a3'], $row['a4'], $row['a5']);

            $fixtures[] = $row;
        }

        header('Content-Type: application/json');
        echo json_encode($fixtures);
    }


    // function getGoalscorers($gw, $division)
    // {
    //     global $db;

    //     if (($gw) == 0) {
    //         $stmt = $db->query("SELECT 
    //                 g.manager_id,
    //                 m.name as player_name,
    //                 SUM(g.goals) as goals,
    //                 SUM(g.points) as points,
    //                 t.team_name,
    //                 t.logo as team_logo
    //             FROM goalscorers g
    //             JOIN managers m ON g.manager_id = m.fpl_id
    //             JOIN teams t ON g.team_id = t.id
    //             WHERE g.division = $division
    //             GROUP BY g.manager_id, m.name, t.team_name, t.logo
    //             ORDER BY goals DESC, points DESC
    //             LIMIT 20");
    //         $goalscorers = [];
    //         while ($row = mysqli_fetch_assoc($stmt)) {
    //             $row['manager_name'] = getFplTeamNameFromDb($row['manager_id']);
    //             $row['manager_team'] = getManagersTeam($row['manager_id']);
    //             $goalscorers[] = $row;
    //         }

    //         header('Content-Type: application/json');
    //         echo json_encode($goalscorers);
    //     } else {
    //         $stmt = $db->query("SELECT * FROM goalscorers WHERE gameweek = '$gw' AND division = '$division'");
    //         $goalscorers = [];
    //         while ($row = mysqli_fetch_assoc($stmt)) {
    //             $row['manager_name'] = getFplTeamNameFromDb($row['manager_id']);
    //             $row['manager_team'] = getManagersTeam($row['manager_id']);
    //             $goalscorers[] = $row;
    //         }

    //         header('Content-Type: application/json');
    //         echo json_encode($goalscorers);
    //     }
    // }

     function getGoalscorers($gw, $division)
    {
        global $db;

        if (($gw) == 0) {
            $stmt = $db->query("SELECT 
                    g.manager_id,
                    m.name as player_name,
                    SUM(g.goals) as goals,
                    SUM(g.points) as points,
                    t.team_name,
                    t.logo as team_logo
                FROM goalscorers g
                JOIN managers m ON g.manager_id = m.fpl_id
                JOIN teams t ON g.team_id = t.id
                WHERE g.division = $division
                GROUP BY g.manager_id, m.name, t.team_name, t.logo
                ORDER BY goals DESC, points DESC
                LIMIT 20");
            $goalscorers = [];
            while ($row = mysqli_fetch_assoc($stmt)) {
                $row['manager_name'] = getFplTeamNameFromDb($row['manager_id']);
                $row['manager_team'] = getManagersTeam($row['manager_id']);
                $goalscorers[] = $row;
            }

            header('Content-Type: application/json');
            echo json_encode($goalscorers);
        } else {
            $stmt = $db->query("SELECT 
                    g.manager_id,
                    m.name as manager_name,
                    g.goals,
                    g.points,
                    t.team_name as manager_team,
                    t.logo as team_logo
                FROM goalscorers g
                JOIN managers m ON g.manager_id = m.fpl_id
                JOIN teams t ON g.team_id = t.id
                WHERE g.division = $division AND g.gameweek = $gw
                ORDER BY g.goals DESC, g.points DESC
                LIMIT 20");
            $goalscorers = [];
            while ($row = mysqli_fetch_assoc($stmt)) {
                // $row['manager_name'] = getFplTeamNameFromDb($row['manager_id']);
                // $row['manager_team'] = getManagersTeam($row['manager_id']);
                $goalscorers[] = $row;
            }

            header('Content-Type: application/json');
            echo json_encode($goalscorers);
        }
    }

    function getManagerDetails($managerId, $gw)
    {
        global $db;
        if (!$managerId) return null;

        // Manager name
        $nameRes = $db->query("SELECT name FROM managers WHERE fpl_id = $managerId LIMIT 1");
        $nameRow = mysqli_fetch_assoc($nameRes);
        $name = $nameRow ? $nameRow['name'] : "Manager $managerId";

        // Points and transfer cost for GW
        $ptsRes = $db->query("SELECT points, transfer_cost, net_points FROM manager_history WHERE manager_id = $managerId AND event = $gw LIMIT 1");
        $ptsRow = mysqli_fetch_assoc($ptsRes);

        $points = $ptsRow ? intval($ptsRow['points']) : 0;
        $transferCost = $ptsRow ? intval($ptsRow['transfer_cost']) : 0;
        $netPoints = $ptsRow ? intval($ptsRow['net_points']) : 0;

        return [
            "id" => intval($managerId),
            "name" => $name,
            "points" => $points,
            "transfer_cost" => $transferCost,
            "net_points" => $netPoints
        ];
    }








    function buildLeagueTable($division)
    {
        global $db;
        // $db->query("TRUNCATE TABLE league_table");
        $db->query("DELETE FROM league_table WHERE division = '$division' ");

        $res = [];
        $sql = $db->query("SELECT * FROM results WHERE division = '$division'");
        while ($result = mysqli_fetch_assoc($sql)) {
            $home_team_id = $result['home_team'];
            $away_team_id = $result['away_team'];
            $hs = ($result['home_goals'] * 1);
            $as = ($result['away_goals'] * 1);
            $gd1 = $hs - $as;
            $gd2 = $as - $hs;

            if ($hs > $as) {
                $stm = $db->query("SELECT * FROM league_table WHERE team_id = '$home_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$hs, goals_against = (goals_against*1)+$as, goal_difference = (goal_difference*1)+$gd1, won = (won*1)+1, points = (points*1)+3 WHERE team_id = '$home_team_id' AND division = '$division' ");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$home_team_id', 1, '$hs', '$as', '$gd1', 1, 0, 0, 3, '$division')");
                }


                $stm2 = $db->query("SELECT * FROM league_table WHERE team_id = '$away_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm2) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$as, goals_against = (goals_against*1)+$hs, goal_difference = (goal_difference*1)+$gd2, lost = (lost*1)+1 WHERE team_id = '$away_team_id' AND division = '$division'");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$away_team_id', 1, '$as', '$hs', '$gd2', 0, 0, 1, 0, '$division')");
                }

                // echo 'Home won: '. $hs.' -Away lost: '. $as. ' ';
            } elseif ($hs < $as) {
                $stm = $db->query("SELECT * FROM league_table WHERE team_id = '$home_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$hs, goals_against = (goals_against*1)+$as, goal_difference = (goal_difference*1)+$gd1, lost = (lost*1)+1 WHERE team_id = '$home_team_id' AND division = '$division'");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$home_team_id', 1, '$hs', '$as', '$gd1', 0, 0, 1, 0, '$division')");
                }


                $stm2 = $db->query("SELECT * FROM league_table WHERE team_id = '$away_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm2) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$as, goals_against = (goals_against*1)+$hs, goal_difference = (goal_difference*1)+$gd2, won = (won*1)+1, points = (points*1)+3 WHERE team_id = '$away_team_id' AND division = '$division'");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$away_team_id', 1, '$as', '$hs', '$gd2', 1, 0, 0, 3, '$division')");
                }
                // echo 'Home lost: '. $hs.' -Away won: '. $as. ' ';
            } else {
                $stm = $db->query("SELECT * FROM league_table WHERE team_id = '$home_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$hs, goals_against = (goals_against*1)+$as, goal_difference = (goal_difference*1)+$gd1, drawn = (drawn*1)+1, points = (points*1)+1 WHERE team_id = '$home_team_id' AND division = '$division'");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$home_team_id', 1, '$hs', '$as', '$gd1', 0, 1, 0, 1, '$division')");
                }


                $stm2 = $db->query("SELECT * FROM league_table WHERE team_id = '$away_team_id' AND division = '$division'");
                if (mysqli_num_rows($stm2) >= 1) {
                    $stmt = $db->query("UPDATE league_table SET played = (played*1)+1, goals_for = (goals_for*1)+$as, goals_against = (goals_against*1)+$hs, goal_difference = (goal_difference*1)+$gd2, drawn = (drawn*1)+1, points = (points*1)+1 WHERE team_id = '$away_team_id' AND division = '$division'");
                } else {
                    $stmt = $db->query("INSERT INTO league_table (team_id, played, goals_for, goals_against, goal_difference, won, drawn, lost, points, division) VALUES ('$away_team_id', 1, '$as', '$hs', '$gd2', 0, 1, 0, 1, '$division')");
                }
                // echo 'Home drew: '. $hs.' -Away drew: '. $as. ' ';
            }
        }
    }

    function refreshLeagueTable($division)
    {
        global $db;

        // Build and fetch
        $this->buildLeagueTable($division);

        $result = $db->query("SELECT t.team_name, t.logo, l.* FROM league_table l JOIN teams t ON t.id = l.team_id WHERE l.division = '$division' ORDER BY (points*1) DESC, (goal_difference*1) DESC,(goals_for*1) DESC");

        $table = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $table[] = $row;
        }

        header('Content-Type: application/json');
        echo json_encode($table);
    }

    function getNextDeadline()
    {
        $url = "https://fantasy.premierleague.com/api/bootstrap-static/";
        $json = curl_fetch_url($url);

        if ($json === false) {
            echo json_encode(["error" => "Unable to fetch FPL data"]);
            return;
        }

        $data = json_decode($json, true);

        if (!isset($data['events'])) {
            echo json_encode(["error" => "No events found"]);
            return;
        }

        // Find next gameweek
        foreach ($data['events'] as $event) {
            if ($event['is_next'] === true) {
                echo json_encode([
                    "id" => $event['id'],
                    "name" => $event['name'],
                    "deadline" => $event['deadline_time'] // UTC
                ]);
                return;
            }
        }

        echo json_encode(["error" => "No upcoming gameweek found"]);
    }

    function getGwInfoCached($gw)
    {
        global $db;
        $res = $db->query("SELECT * FROM gameweek_status WHERE gw='$gw'");
        if ($row = mysqli_fetch_assoc($res)) {
            return $row;
        }

        // Not in DB, fetch once from FPL API
        $url = "https://fantasy.premierleague.com/api/bootstrap-static/";
        $data = json_decode(curl_fetch_url($url), true);

        foreach ($data['events'] as $event) {
            if ($event['id'] == $gw) {
                $status = $event['finished'] ? "Closed" : ($event['is_current'] ? "Live" : "Pending");
                $deadline = $event['deadline_time'];
                $db->query("INSERT INTO gameweek_status (gw, status, deadline) VALUES ('$gw', '$status', '$deadline')
                        ON DUPLICATE KEY UPDATE status='$status', deadline = '$deadline'");
                return $status;
            }
        }

        return "Pending";
    }

    function fetchLeagueTeams()
    {
        global $db;
        $info = [];
        $sql = $db->query("SELECT * FROM teams ORDER BY team_name");
        while ($row = mysqli_fetch_assoc($sql)) {
            $info[] = $row;
        }

        header('Content-Type: application/json');
        echo json_encode($info);
    }

    function getOverallTeamRankings()
    {
        global $db;
        // 1. Fetch all teams and their managers
        $teams_query = $db->query("SELECT id, team_name, manager1, manager2, manager3, manager4, manager5 FROM teams");
        $teams = [];

        while ($row = mysqli_fetch_assoc($teams_query)) {
            $teamId = $row['id'];
            $teams[$teamId] = [
                'team_name' => $row['team_name'],
                'managers' => [
                    (int)$row['manager1'],
                    (int)$row['manager2'],
                    (int)$row['manager3'],
                    (int)$row['manager4'],
                    (int)$row['manager5']
                ],
                'total_points' => 0
            ];
        }

        // 2. Fetch all manager histories (manager_id + net_points)
        $histories_query = $db->query("SELECT manager_id, net_points FROM manager_history");

        $managerTotals = [];

        while ($row = mysqli_fetch_assoc($histories_query)) {
            $id = (int)$row['manager_id'];
            $points = (int)$row['net_points'];

            if (!isset($managerTotals[$id])) {
                $managerTotals[$id] = 0;
            }
            $managerTotals[$id] += $points;
        }

        // 3. Add each manager’s total to their team’s total
        foreach ($teams as &$team) {
            foreach ($team['managers'] as $managerId) {
                if (isset($managerTotals[$managerId])) {
                    $team['total_points'] += $managerTotals[$managerId];
                }
            }
        }
        unset($team);

        // 4. Sort teams by total points (descending)
        usort($teams, function ($a, $b) {
            return $b['total_points'] <=> $a['total_points'];
        });

        // 5. Add rank numbers
        $ranked = [];
        $rank = 1;
        foreach ($teams as $team) {
            $ranked[] = [
                'rank' => $rank++,
                'team_name' => $team['team_name'],
                'total_points' => $team['total_points']
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($rank);
    }


    function getDivTeamRankings($div)
    {
        global $db;
        // 1. Fetch all teams and their managers
        $teams_query = $db->query("SELECT id, team_name, manager1, manager2, manager3, manager4, manager5 FROM teams WHERE division = $div");
        $teams = [];

        while ($row = mysqli_fetch_assoc($teams_query)) {
            $teamId = $row['id'];
            $teams[$teamId] = [
                'team_name' => $row['team_name'],
                'managers' => [
                    (int)$row['manager1'],
                    (int)$row['manager2'],
                    (int)$row['manager3'],
                    (int)$row['manager4'],
                    (int)$row['manager5']
                ],
                'total_points' => 0
            ];
        }

        // 2. Fetch all manager histories (manager_id + net_points)
        $histories_query = $db->query("SELECT manager_id, net_points FROM manager_history");

        $managerTotals = [];

        while ($row = mysqli_fetch_assoc($histories_query)) {
            $id = (int)$row['manager_id'];
            $points = (int)$row['net_points'];

            if (!isset($managerTotals[$id])) {
                $managerTotals[$id] = 0;
            }
            $managerTotals[$id] += $points;
        }

        // 3. Add each manager’s total to their team’s total
        foreach ($teams as &$team) {
            foreach ($team['managers'] as $managerId) {
                if (isset($managerTotals[$managerId])) {
                    $team['total_points'] += $managerTotals[$managerId];
                }
            }
        }
        unset($team);

        // 4. Sort teams by total points (descending)
        usort($teams, function ($a, $b) {
            return $b['total_points'] <=> $a['total_points'];
        });

        // 5. Add rank numbers
        $ranked = [];
        $rank = 1;
        foreach ($teams as $team) {
            $ranked[] = [
                'rank' => $rank++,
                'team_name' => $team['team_name'],
                'total_points' => $team['total_points']
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($ranked);
    }
}


$pro = new Maestros;
